<?php

/**
 * 
 * 
 *
 * @link              www.scrollsequence.com
 * @since             0.7.0
 * @package           Scrollsequence
 *
 * @wordpress-plugin
 * Plugin Name:       Scrollsequence
 * Plugin URI:        https://www.scrollsequence.com
 * Description:       Create stunning image animation that play and rewind on scroll. Make your website come alive with just few clicks.  
 * Version:           2.0.0-beta.3
 * Author:            Scrollsequence
 * Author URI:        https://www.scrollsequence.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       scrollsequence
 * Domain Path:       v1/languages
 * 
 *   Věnování:
 *   Tento plugin je věnován mé rodině – mamince Světle,
 *   manželce Veronice, dětem Natálce a Alexovi
 *   a naší dceři Agátce, která navždy zůstane v našich srdcích.
 *
 *   Dedication:
 *   This plugin is dedicated to my family – my mother Světla,
 *   my wife Veronika, my children Natálka and Alex,
 *   and our daughter Agátka, who will forever remain in our hearts.
 * 
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( function_exists( 'freemius_scrollsequence' ) ) {
    freemius_scrollsequence()->set_basename( false, __FILE__ );
} else {
    // DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE `function_exists` CALL ABOVE TO PROPERLY WORK.
    if ( !function_exists( 'freemius_scrollsequence' ) ) {
        // ... Freemius integration snippet ...
        // FREEMIUS  COPY START
        if ( !function_exists( 'freemius_scrollsequence' ) ) {
            // Create a helper function for easy SDK access.
            function freemius_scrollsequence() {
                global $freemius_scrollsequence;
                if ( !isset( $freemius_scrollsequence ) ) {
                    // Include Freemius SDK.
                    require_once dirname( __FILE__ ) . '/includes/freemius/start.php';
                    // v1 ish
                    $freemius_scrollsequence = fs_dynamic_init( array(
                        'id'              => '5856',
                        'slug'            => 'scrollsequence',
                        'premium_slug'    => 'scrollsequence-pro',
                        'type'            => 'plugin',
                        'public_key'      => 'pk_ea24bea874c80814ebc58bc230264',
                        'is_premium'      => false,
                        'has_addons'      => false,
                        'has_paid_plans'  => true,
                        'trial'           => array(
                            'days'               => 14,
                            'is_require_payment' => false,
                        ),
                        'has_affiliation' => 'all',
                        'menu'            => array(
                            'slug'       => 'scrollsequence-dashboard',
                            'first-path' => 'admin.php?page=scrollsequence-dashboard',
                            'support'    => false,
                        ),
                        'is_live'         => true,
                    ) );
                }
                return $freemius_scrollsequence;
            }

            // Init Freemius.
            freemius_scrollsequence();
            // Signal that SDK was initiated.
            do_action( 'freemius_scrollsequence_loaded' );
        }
        // FREEMIUS COPY END
    }
    // ... Your plugin's main file logic ...
    // If this file is called directly, abort.
    if ( !defined( 'WPINC' ) ) {
        die;
    }
    // Define constants.
    define( 'SCROLLSEQUENCE_VERSION', '2.0.0-beta.3' );
    if ( !defined( 'SCROLLSEQUENCE_API_URL' ) ) {
        // can be pre-defined in wp-config.php for local development
        define( 'SCROLLSEQUENCE_API_URL', 'https://api.scrollsequence.com' );
    }
    // Plan title helper function (used in v1 and v2 dashboards)
    function scrollsequence_get_plan_title() {
        return 'Free<span class="ssqplan-free-5" />';
        // free version always shows Free, even though it has a plan or plan trial activated.
    }

    // Initialize the plugin.
    $scrollsequence_active_version = get_option( 'scrollsequence_active_version', 'v1' );
    // load switch render ui function
    require_once __DIR__ . '/switch.php';
    if ( $scrollsequence_active_version === 'v2' ) {
        require_once __DIR__ . '/v2/scrollsequence-v2.php';
    } else {
        require_once __DIR__ . '/v1/scrollsequence-v1.php';
    }
    // In scrollsequence.php (main file)
    function scrollsequence_maybe_flush_rewrites() {
        if ( get_transient( 'scrollsequence_flush_rewrite_rules' ) ) {
            flush_rewrite_rules();
            delete_transient( 'scrollsequence_flush_rewrite_rules' );
        }
    }

    add_action( 'init', 'scrollsequence_maybe_flush_rewrites' );
}