<?php 
// see: https://developer.wordpress.org/block-editor/how-to-guides/data-basics/1-data-basics-setup/

function scroll_sequence_dashboard_menu() {
    // Create a new admin page for our app.
    add_menu_page(
        __( 'Scrollsequence 2', 'scrollsequence' ),
        __( 'Scrollsequence 2', 'scrollsequence' ),
        'manage_options',
        'scrollsequence-dashboard',
        'scroll_sequence_dashboard_page', // Function to display the page content
        plugin_dir_url(__FILE__) . 'public/logo-wp-admin-sidebar.svg',  //'dashicons-welcome-view-site', 
        22
    );

    // Add submenu at zero-th position
    add_submenu_page(
        'scrollsequence-dashboard', // Parent slug
        'Dashboard', // Page title
        'Dashboard', // Menu title
        'manage_options', // Capability
        'scrollsequence-dashboard', // Menu slug
        'scroll_sequence_dashboard_page', // Function to display the page content
        0 // Position
    );
    // Add submenu "Add new"
    // add_submenu_page(
    //     'scrollsequence-dashboard', // Parent slug
    //     'Add New', // Page title
    //     'Add New', // Menu title
    //     'manage_options', // Capability
    //     'post-new.php?post_type=scroll-sequence', // Menu slug
    //     '', // Function to display the page content
    //     2 // Position
    // );
}
add_action( 'admin_menu', 'scroll_sequence_dashboard_menu' );

// This is required for wp.media to be enqueued in the admin for file upload
function scroll_sequence_enqueue_media_uploader() {    
    wp_enqueue_media(); 
} 
add_action('admin_enqueue_scripts', 'scroll_sequence_enqueue_media_uploader');

/**
 * DASHBOARD 
 */
function scroll_sequence_dashboard_page() {
    ob_start();
    ?>
    <h2 style="display: flex; align-items: center; gap:10px; margin-left:20px">
        <img src="<?php echo esc_url( plugin_dir_url(__FILE__) . 'public/logo.svg' ); ?>" style="filter: grayscale(1);" width="40" height="40" alt="Scrollsequence Logo"/> 
        <span>
            Scrollsequence 2
        </span>
        <span style="font-size:14px; font-weight:500; color:gray; text-transform: capitalize;" >
            <?php echo scrollsequence_get_plan_title(); ?>               
        </span>
        <span style="font-size:12px; font-weight:500; color:gray"><?php echo wp_kses_post( SCROLLSEQUENCE_VERSION );?> </span>
    </h2>
    <div style="padding-left: 50px">
        <?php echo scrollsequence_switch_version_render('v2'); ?>    
    </div>
    <div style="margin-right:20px; margin-bottom:16px; display:flex; gap:16px; align-items:center; justify-content:end;">
        <a href="https://docs.scrollsequence.com/" target="_blank">
           Documentation
            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-box-arrow-up-right" viewBox="0 0 16 16">
                <path fill-rule="evenodd" d="M8.636 3.5a.5.5 0 0 0-.5-.5H1.5A1.5 1.5 0 0 0 0 4.5v10A1.5 1.5 0 0 0 1.5 16h10a1.5 1.5 0 0 0 1.5-1.5V7.864a.5.5 0 0 0-1 0V14.5a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5v-10a.5.5 0 0 1 .5-.5h6.636a.5.5 0 0 0 .5-.5"/>
                <path fill-rule="evenodd" d="M16 .5a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h3.793L6.146 9.146a.5.5 0 1 0 .708.708L15 1.707V5.5a.5.5 0 0 0 1 0z"/>
            </svg>           
        </a>
        
        <a href="https://scrollsequence.com"><span class="dashicons dashicons-admin-site-alt3" style="color:black;text-decoration: none;"></span></a>
        <a href="https://www.youtube.com/@scrollsequence"><span class="dashicons dashicons-youtube" style="color:#FF0000;text-decoration: none;"></span></a>
        <a href="https://www.facebook.com/scrollsequence"><span class="dashicons dashicons-facebook" style="color:#4267B2;text-decoration: none;"></span></a>
        <a href="https://twitter.com/scrollsequence"><span class="dashicons dashicons-twitter" style="color:#1DA1F2;text-decoration: none;"></span></a>
        <a href="https://www.instagram.com/scrollsequence/"><span class="dashicons dashicons-instagram" style="color:#fb3958;text-decoration: none;"></span></a>

    </div>
    <div id="scrollsequence-dashboard">Loading...</div>

    <a 
        href="https://docs.scrollsequence.com/v2-feedback" 
        target="_blank" 
        style="position:fixed; bottom:30px; right:30px; cursor: pointer; line-height: 50px; justify-content: space-around; z-index:9; display:flex; align-items:center; gap:0px; padding:8px 8px; background-color:rgb(25, 25, 25); width: 140px; height:50px; border-radius:30px; text-decoration:none; color:white;">

        <span class="dashicons dashicons-admin-comments" style="width: 30px; height: 30px;  font-size: 30px;"></span>

        <span style="font-size: 16px; font-weight: 600;  white-space: nowrap;  line-height: 16px;">Feedback</span>
    </a>

    <?php
    echo ob_get_clean();
}
function scroll_sequence_dashboard_scripts( $hook ) {
    // Load only on ?page=scrollsequence-dashboard.
    //echo var_dump($hook);
    if ( 'toplevel_page_scrollsequence-dashboard' !== $hook ) {
        return;
    }

    // localize (same as in gutenberg) - needs to run before the main dashboard script is loaded, ideally this should be a dependency but for now this works
    scroll_sequence_localize_editor(); // we need scroll_sequence_editor_data.siteUrl for the links in the dashboard


    // Load the required WordPress packages.
    // Automatically load imported dependencies and assets version.
    $asset_file = include plugin_dir_path( __FILE__ ) . 'build/dashboard.asset.php';

    // Enqueue CSS dependencies.
    foreach ( $asset_file['dependencies'] as $style ) {
        wp_enqueue_style( $style );
    }
    // Load our app.js.
    wp_register_script(
        'scrollsequence-dashboard',
        plugins_url( 'build/dashboard.js', __FILE__ ),
        $asset_file['dependencies'],
        $asset_file['version'],
        true
    );
    wp_enqueue_script( 'scrollsequence-dashboard' );

    // Load our style.css.
    wp_register_style(
        'scrollsequence-dashboard',
        plugins_url( 'src/dashboard/dashboard.css', __FILE__ ),
        array(),
        $asset_file['version']
    );
    wp_enqueue_style( 'scrollsequence-dashboard' );


}
add_action( 'admin_enqueue_scripts', 'scroll_sequence_dashboard_scripts' );


