<?php 
// see: General Info: https://developer.wordpress.org/themes/patterns/introduction-to-patterns/
// see: Patterns (block editor dev):  https://developer.wordpress.org/block-editor/reference-guides/block-api/block-patterns/
// see: Starter Patterns: https://developer.wordpress.org/themes/patterns/starter-patterns/

/**
 * 
 * FOR MY INFORMATION:
 *  Patterns live here but also: 
 *     - scroll-sequence post type Template (1-post-types.php) have a "pattern" type of object.
 *     - example of the individual blocks (block.json example in src/v2/blocks/canvas2d/block.json)
 * 
 */

// This function is used to avoid the need to escape the HTML in the pattern content string.
function scroll_sequence_render_pattern_content($callback) {
    ob_start();
    $callback();
    return ob_get_clean();
}

function scroll_sequence_get_starter_post_types() {
    // All post types that use the block editor (show_in_rest = true)
    return array_values( get_post_types( [ 'show_in_rest' => true ] ) );
}

function scroll_sequence_register_v2_patterns() {

    // Register the block pattern category
    register_block_pattern_category(
        'scroll-sequence',
        array( 'label' => __( 'Scrollsequence', 'scrollsequence' ) )
    );


    // Canvas 2D Beauty Pattern
    register_block_pattern(
        'scroll-sequence/beauty',
        [
            'title'       => __( 'Scrollsequence Pattern: Canvas 2D Beauty', 'scrollsequence' ),
            'description' => _x( 
                'Scrollsequence Canvas 2D Beauty Pattern', // text
                'Block pattern description',  // context
                'scrollsequence' // domain
            ),
            'viewportWidth' => 1600, 
            'viewportHeight' => 900,  

            'blockTypes' => [ 'core/post-content' ],                    // YES - this turns on the pattern only for starter patterns
            'postTypes' => scroll_sequence_get_starter_post_types(),    // YES - get post types that use block editor so that it is set for starter patterns explicitly

            'categories' => [ 'scroll-sequence' ],
            'content' => scroll_sequence_render_pattern_content(function () {
                ?>
                    <!-- wp:group {"align":"full","layout":{"type":"default"}} -->
                    <div class="wp-block-group alignfull">
                        
                        <!-- wp:scroll-sequence/v2-scene {"triggerStart":0.89,"align":"full","layout":{"type":"default"}} -->
                        <!-- wp:scroll-sequence/v2-canvas2d {"width":100,"widthUnit":"%","height":100,"heightUnit":"vh","mediaGroups":[{"type":"urlList","images":["00103","00109","00115","00121","00127","00133","00139","00145","00151","00157","00163","00169","00175","00181","00187","00193","00199","00205","00211","00217","00223","00229","00235","00241","00247","00253","00259","00265","00271","00277","00283","00289","00295","00301","00307","00313","00319","00325","00331","00337","00343","00349","00355","00361","00367","00373","00379","00385","00391","00397","00403","00409","00415","00421","00427","00433","00439","00433","00427","00421","00415","00409","00403","00397","00391","00385","00379","00373","00367","00361","00355","00349","00343","00337","00331","00325","00319","00313","00307","00301","00295","00289","00283","00277","00271","00265","00259","00253","00247","00241","00235","00229","00223","00217","00211","00205","00199","00193","00187","00181","00175","00169","00163","00157","00151","00145","00139","00133","00127","00121","00115","00109","00103","00097","00091","00085","00079","00073","00067","00061","00055","00049","00043","00037","00031","00025","00019","00013","00007","00001"],"duration":1,"bgSize":"cover","bgPosition":{"x":0.5,"y":0.5},"prefix":"https://cdn.scrollsequence.com/v1-beauty/beauty","suffix":".jpeg"}],"triggerStart":0.75,"triggerEnd":0.75} /-->

                        <!-- wp:heading {"textAlign":"center","className":"is-style-default","fontSize":"xx-large","ssqAnimateOnScroll":{"to":{"keyframes":{"0%":{"filter":"blur(10px)","y":100,"autoAlpha":0},"40%":{"y":0,"filter":"blur(0)","autoAlpha":1},"80%":{"y":0,"filter":"blur(0)","autoAlpha":1},"90%":{"y":-100,"filter":"blur(1.5rem)","autoAlpha":0}},"ease":"none","duration":2}}} -->
                        <h2 class="wp-block-heading has-text-align-center is-style-default has-xx-large-font-size">Another day on Earth</h2>
                        <!-- /wp:heading -->
                        <!-- /wp:scroll-sequence/v2-scene -->
                        
                    </div>
                    <!-- /wp:group -->
                <?php
            }),
        ]
    );    

    // Canvas 2D Fixed DNA Pattern
    register_block_pattern(
        'scroll-sequence/dna',
        [
            'title'       => __( 'Scrollsequence Pattern: Canvas 2D Fixed DNA', 'scrollsequence' ),
            'description' => _x( 
                'Scrollsequence Canvas 2D Fixed DNA Pattern', // text
                'Block pattern description',  // context
                'scrollsequence' // domain
            ),
            'viewportWidth' => 1600, 
            'viewportHeight' => 900,  

            'blockTypes' => [ 'core/post-content' ],                    // YES - this turns on the pattern only for starter patterns
            'postTypes' => scroll_sequence_get_starter_post_types(),    // YES - get post types that use block editor so that it is set for starter patterns explicitly

            'categories' => [ 'scroll-sequence' ],
            'content' => scroll_sequence_render_pattern_content(function () {
                ?>
                    <!-- wp:group {"align":"full","layout":{"type":"default"}} -->
                    <div class="wp-block-group alignfull">
                        <!-- wp:scroll-sequence/v2-scene {"scenePosition":"fixed","triggerStart":0.87, "align":"full","layout":{"type":"default"}} -->
                        <!-- wp:scroll-sequence/v2-canvas2d {"height":100,"mediaGroups":[{"type":"urlList","images":["0001","0002","0003","0004","0005","0006","0007","0008","0009","0010","0011","0012","0013","0014","0015","0016","0017","0018","0019","0020","0021","0022","0023","0024","0025","0026","0027","0028","0029","0030","0031","0032","0033","0034","0035","0036","0037","0038","0039","0040","0041","0042","0043","0044","0045","0046","0047","0048","0049","0050","0051","0052","0053","0054","0055","0056","0057","0058","0059","0060","0061","0062","0063","0064","0065","0066","0067","0068","0069","0070","0071","0072","0073","0074","0075","0076","0077","0078","0079","0080","0081","0082","0083","0084","0085","0086","0087","0088","0089","0090","0091","0092","0093","0094","0095","0096","0097","0098","0099","0100","0101","0102","0103","0104","0105","0106","0107","0108","0109","0110","0111","0112","0113","0114","0115","0116","0117","0118","0119","0120","0121","0122","0123","0124","0125","0126","0127","0128","0129","0130","0131","0132","0133","0134","0135","0136","0137","0138","0139","0140","0141","0142","0143","0144","0145","0146","0147","0148","0149","0150","0151","0152","0153","0154","0155","0156","0157","0158","0159","0160","0161","0162","0163","0164","0165","0166","0167","0168","0169","0170","0171","0172","0173","0174","0175","0176","0177","0178","0179","0180","0181","0182","0183","0184","0185","0186","0187","0188","0189","0190","0191","0192","0193","0194","0195","0196","0197","0198","0199","0200","0201","0202","0203","0204","0205","0206","0207","0208","0209","0210","0211","0212","0213","0214","0215","0216","0217","0218","0219","0220","0221","0222","0223","0224","0225","0226","0227","0228","0229","0230","0231","0232","0233","0234","0235","0236","0237","0238","0239","0240","0241","0242","0243","0244","0245","0246","0247","0248","0249","0250","0251","0252","0253","0254","0255","0256","0257","0258","0259","0260","0261","0262","0263","0264","0265","0266","0267","0268","0269","0270","0271","0272","0273","0274","0275","0276","0277","0278","0279","0280","0281","0282","0283","0284","0285","0286","0287","0288","0289","0290","0291","0292","0293"],"duration":1,"bgSize":"cover","bgPosition":{"x":0.5,"y":0.5},"prefix":"https://cdn.scrollsequence.com/v1-dna/dna200_","suffix":".jpg"}]} /-->

                        <!-- wp:group {"layout":{"type":"constrained"},"ssqAnimateOnScroll":{"to":{"keyframes":{"60%":{"filter":"blur(0)","autoAlpha":1},"100%":{"filter":"blur(50px)","y":-200,"autoAlpha":1},"easeEach":"expo.inOut"},"ease":"none","duration":2}}} -->
                        <div class="wp-block-group"><!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"1000"}},"textColor":"base","fontSize":"xx-large","ssqAnimateOnScroll":{"to":{"keyframes":{"0%":{"y":100,"autoAlpha":0},"20%":{"y":0,"autoAlpha":1},"80%":{"y":0,"autoAlpha":1},"100%":{"y":-100,"autoAlpha":0}},"ease":"none","duration":2}}} -->
                        <p class="has-text-align-center has-base-color has-text-color has-link-color has-xx-large-font-size" style="font-style:normal;font-weight:1000">Hello World</p>
                        <!-- /wp:paragraph -->

                        <!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"typography":{"fontStyle":"normal","fontWeight":"700"}},"textColor":"base","fontSize":"x-large","ssqAnimateOnScroll":{"to":{"keyframes":{"0%":{"y":100,"autoAlpha":0},"30%":{"y":100,"autoAlpha":0},"40%":{"y":0,"autoAlpha":1},"80%":{"y":0,"autoAlpha":1},"100%":{"y":-100,"autoAlpha":0}},"ease":"none","duration":2}}} -->
                        <p class="has-text-align-center has-base-color has-text-color has-link-color has-x-large-font-size" style="font-style:normal;font-weight:700">Lorem Ipsum</p>
                        <!-- /wp:paragraph -->

                        <!-- wp:buttons {"style":{"typography":{"fontStyle":"normal","fontWeight":"700"}},"fontSize":"x-large","layout":{"type":"flex","justifyContent":"center"},"ssqAnimateOnScroll":{"to":{"keyframes":{"0%":{"y":100,"autoAlpha":0},"40%":{"y":100,"autoAlpha":0},"50%":{"y":0,"autoAlpha":1},"80%":{"y":0,"autoAlpha":1},"100%":{"y":-100,"autoAlpha":0}},"ease":"none","duration":2}}} -->
                        <div class="wp-block-buttons has-custom-font-size has-x-large-font-size" style="font-style:normal;font-weight:700"><!-- wp:button -->
                        <div class="wp-block-button"><a class="wp-block-button__link wp-element-button">Click me!</a></div>
                        <!-- /wp:button --></div>
                        <!-- /wp:buttons --></div>
                        <!-- /wp:group -->
                        <!-- /wp:scroll-sequence/v2-scene -->
                        

                        <!-- wp:spacer {"height":"600px"} -->
                        <div style="height:600px" aria-hidden="true" class="wp-block-spacer"></div>
                        <!-- /wp:spacer -->
                    </div>
                    <!-- /wp:group -->
                <?php
            }),
        ]
    );    


    // Canvas 3D Robot Pattern
    register_block_pattern(
        'scroll-sequence/robot',
        [
            'title'       => __( 'Scrollsequence Pattern: Canvas 3D Robot', 'scrollsequence' ),
            'description' => _x( 
                'Scrollsequence Canvas 2D Robot Pattern', // text
                'Block pattern description',  // context
                'scrollsequence' // domain
            ),
            'viewportWidth' => 1600, 
            'viewportHeight' => 900,  

            // NO blockTypes here – that’s what keeps it out of the starter popup
            // NO postTypes here either – pattern will be usable in all editors

            'categories' => [ 'scroll-sequence' ],
            'content' => scroll_sequence_render_pattern_content(function () {
                ?>
                    <!-- wp:group {"align":"full","layout":{"type":"default"}} -->
                    <div class="wp-block-group alignfull">
                        <!-- wp:scroll-sequence/v2-scene {"duration":1250, "align":"full","layout":{"type":"default"}} -->
                            <!-- wp:scroll-sequence/v2-canvas3d {"height":100,"splinecodeurl":"https://cdn.scrollsequence.com/spline/robot.splinecode","variables":{"hele":"Tak co nebo co?","title":"Hello :-)"}} /-->

                            <!-- wp:group {"className":"is-style-default","style":{"spacing":{"padding":{"right":"var:preset|spacing|40","left":"var:preset|spacing|40","top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"layout":{"type":"constrained"},"ssqAnimateOnScroll":{"to":{"keyframes":{"0%":{"backgroundColor":"rgba(255,255,255, 0.4)","autoAlpha":0},"27%":{"scale":0,"autoAlpha":0},"37%":{"y":0,"scale":1,"autoAlpha":1},"70%":{"autoAlpha":1}},"ease":"none","duration":2}},"ssqSceneAlign":"bottom center"} -->
                            <div class="wp-block-group is-style-default" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40)"><!-- wp:heading {"className":"is-style-default","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast","fontSize":"xx-large","ssqSceneAlign":"bottom center"} -->
                            <h2 class="wp-block-heading is-style-default has-contrast-color has-text-color has-link-color has-xx-large-font-size">WordPress Scroll Animation</h2>
                            <!-- /wp:heading -->

                            <!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast","ssqAnimateOnScroll":{"to":{"keyframes":{"0%":{"autoAlpha":0},"60%":{"autoAlpha":0},"75%":{"autoAlpha":1},"100%":{"x":0,"y":0},"easeEach":"expo.inOut"},"ease":"none","duration":2}}} -->
                            <p class="has-contrast-color has-text-color has-link-color">This example is consisting of a Canvas 3D block, which is nested inside a container block and fixed to the scene using scene block.</p>
                            <!-- /wp:paragraph -->

                            <!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
                            <div class="wp-block-buttons"><!-- wp:button {"ssqAnimateOnScroll":{"to":{"keyframes":{"0%":{"autoAlpha":0},"65%":{"autoAlpha":0},"80%":{"autoAlpha":1},"100%":{"x":0,"y":0},"easeEach":"expo.inOut"},"ease":"none","duration":2}}} -->
                            <div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="http://docs.scrollsequence.com/v2">Learn more</a></div>
                            <!-- /wp:button --></div>
                            <!-- /wp:buttons --></div>
                            <!-- /wp:group -->
                        <!-- /wp:scroll-sequence/v2-scene -->
                    </div>
                    <!-- /wp:group -->
                <?php
            }),
        ]
    );   

    // Canvas 3D Flying High Pattern
    register_block_pattern(
        'scroll-sequence/flying-high',
        [
            'title'       => __( 'Scrollsequence Pattern: Canvas 3D Flying High', 'scrollsequence' ),
            'description' => _x( 
                'Scrollsequence Canvas 3D Flying High Pattern', // text
                'Block pattern description',  // context
                'scrollsequence' // domain
            ),
            'viewportWidth' => 1600, 
            'viewportHeight' => 900, 

            // NO blockTypes here – that’s what keeps it out of the starter popup
            // NO postTypes here either – pattern will be usable in all editors
            
            'categories' => [ 'scroll-sequence' ],
            'content' => scroll_sequence_render_pattern_content(function () {
                ?>
                    <!-- wp:group {"align":"full","layout":{"type":"default"}} -->
                    <div class="wp-block-group alignfull">

                        
                        <!-- wp:scroll-sequence/v2-scene {"duration":1500,"scrub":0.3,"triggerStart":0.91,"align":"full","layout":{"type":"default"}} -->
                        <!-- wp:scroll-sequence/v2-canvas2d {"height":100,"mediaGroups":[{"type":"urlList","images":["clouds-0238.jpeg","clouds-0237.jpeg","clouds-0236.jpeg","clouds-0235.jpeg","clouds-0234.jpeg","clouds-0233.jpeg","clouds-0232.jpeg","clouds-0231.jpeg","clouds-0230.jpeg","clouds-0229.jpeg","clouds-0228.jpeg","clouds-0227.jpeg","clouds-0226.jpeg","clouds-0225.jpeg","clouds-0224.jpeg","clouds-0223.jpeg","clouds-0222.jpeg","clouds-0221.jpeg","clouds-0220.jpeg","clouds-0219.jpeg","clouds-0218.jpeg","clouds-0217.jpeg","clouds-0216.jpeg","clouds-0215.jpeg","clouds-0214.jpeg","clouds-0213.jpeg","clouds-0212.jpeg","clouds-0211.jpeg","clouds-0210.jpeg","clouds-0209.jpeg","clouds-0208.jpeg","clouds-0207.jpeg","clouds-0206.jpeg","clouds-0205.jpeg","clouds-0204.jpeg","clouds-0203.jpeg","clouds-0202.jpeg","clouds-0201.jpeg","clouds-0200.jpeg","clouds-0199.jpeg","clouds-0198.jpeg","clouds-0197.jpeg","clouds-0196.jpeg","clouds-0195.jpeg","clouds-0194.jpeg","clouds-0193.jpeg","clouds-0192.jpeg","clouds-0191.jpeg","clouds-0190.jpeg","clouds-0189.jpeg","clouds-0188.jpeg","clouds-0187.jpeg","clouds-0186.jpeg","clouds-0185.jpeg","clouds-0184.jpeg","clouds-0183.jpeg","clouds-0182.jpeg","clouds-0181.jpeg","clouds-0180.jpeg","clouds-0179.jpeg","clouds-0178.jpeg","clouds-0177.jpeg","clouds-0176.jpeg","clouds-0175.jpeg","clouds-0174.jpeg","clouds-0173.jpeg","clouds-0172.jpeg","clouds-0171.jpeg","clouds-0170.jpeg","clouds-0169.jpeg","clouds-0168.jpeg","clouds-0167.jpeg","clouds-0166.jpeg","clouds-0165.jpeg","clouds-0164.jpeg","clouds-0163.jpeg","clouds-0162.jpeg","clouds-0161.jpeg","clouds-0160.jpeg","clouds-0159.jpeg","clouds-0158.jpeg","clouds-0157.jpeg","clouds-0156.jpeg","clouds-0155.jpeg","clouds-0154.jpeg","clouds-0153.jpeg","clouds-0152.jpeg","clouds-0151.jpeg","clouds-0150.jpeg","clouds-0149.jpeg","clouds-0148.jpeg","clouds-0147.jpeg","clouds-0146.jpeg","clouds-0145.jpeg","clouds-0144.jpeg","clouds-0143.jpeg","clouds-0142.jpeg","clouds-0141.jpeg","clouds-0140.jpeg","clouds-0139.jpeg","clouds-0138.jpeg","clouds-0137.jpeg","clouds-0136.jpeg","clouds-0135.jpeg","clouds-0134.jpeg","clouds-0133.jpeg","clouds-0132.jpeg","clouds-0131.jpeg","clouds-0130.jpeg","clouds-0129.jpeg","clouds-0128.jpeg","clouds-0127.jpeg","clouds-0126.jpeg","clouds-0125.jpeg","clouds-0124.jpeg","clouds-0123.jpeg","clouds-0122.jpeg","clouds-0121.jpeg","clouds-0120.jpeg","clouds-0119.jpeg","clouds-0118.jpeg","clouds-0117.jpeg","clouds-0116.jpeg","clouds-0115.jpeg","clouds-0114.jpeg","clouds-0113.jpeg","clouds-0112.jpeg","clouds-0111.jpeg","clouds-0110.jpeg","clouds-0109.jpeg","clouds-0108.jpeg","clouds-0107.jpeg","clouds-0106.jpeg","clouds-0105.jpeg","clouds-0104.jpeg","clouds-0103.jpeg","clouds-0102.jpeg","clouds-0101.jpeg","clouds-0100.jpeg","clouds-0099.jpeg","clouds-0098.jpeg","clouds-0097.jpeg","clouds-0096.jpeg","clouds-0095.jpeg","clouds-0094.jpeg","clouds-0093.jpeg","clouds-0092.jpeg","clouds-0091.jpeg","clouds-0090.jpeg","clouds-0089.jpeg","clouds-0088.jpeg","clouds-0087.jpeg","clouds-0086.jpeg","clouds-0085.jpeg","clouds-0084.jpeg","clouds-0083.jpeg","clouds-0082.jpeg","clouds-0081.jpeg","clouds-0080.jpeg","clouds-0079.jpeg","clouds-0078.jpeg","clouds-0077.jpeg","clouds-0076.jpeg","clouds-0075.jpeg","clouds-0074.jpeg","clouds-0073.jpeg","clouds-0072.jpeg","clouds-0071.jpeg","clouds-0070.jpeg","clouds-0069.jpeg","clouds-0068.jpeg","clouds-0067.jpeg","clouds-0066.jpeg","clouds-0065.jpeg","clouds-0064.jpeg","clouds-0063.jpeg","clouds-0062.jpeg","clouds-0061.jpeg","clouds-0060.jpeg","clouds-0059.jpeg","clouds-0058.jpeg","clouds-0057.jpeg","clouds-0056.jpeg","clouds-0055.jpeg","clouds-0054.jpeg","clouds-0053.jpeg","clouds-0052.jpeg","clouds-0051.jpeg","clouds-0050.jpeg","clouds-0049.jpeg","clouds-0048.jpeg","clouds-0047.jpeg","clouds-0046.jpeg","clouds-0045.jpeg","clouds-0044.jpeg","clouds-0043.jpeg","clouds-0042.jpeg","clouds-0041.jpeg","clouds-0040.jpeg","clouds-0039.jpeg","clouds-0038.jpeg","clouds-0037.jpeg","clouds-0036.jpeg","clouds-0035.jpeg","clouds-0034.jpeg","clouds-0033.jpeg","clouds-0032.jpeg","clouds-0031.jpeg","clouds-0030.jpeg","clouds-0029.jpeg","clouds-0028.jpeg","clouds-0027.jpeg","clouds-0026.jpeg","clouds-0025.jpeg","clouds-0024.jpeg","clouds-0023.jpeg","clouds-0022.jpeg","clouds-0021.jpeg","clouds-0020.jpeg","clouds-0019.jpeg","clouds-0018.jpeg","clouds-0017.jpeg","clouds-0016.jpeg","clouds-0015.jpeg","clouds-0014.jpeg","clouds-0013.jpeg","clouds-0012.jpeg","clouds-0011.jpeg","clouds-0010.jpeg","clouds-0009.jpeg","clouds-0008.jpeg","clouds-0007.jpeg","clouds-0006.jpeg","clouds-0005.jpeg","clouds-0004.jpeg","clouds-0003.jpeg","clouds-0002.jpeg","clouds-0001.jpeg"],"duration":1,"bgSize":"cover","bgPosition":{"x":0.5,"y":0.5},"prefix":"https://cdn.scrollsequence.com/v2-flying-over-clouds/","suffix":""}]} /-->

                        <!-- wp:scroll-sequence/v2-canvas3d {"height":100,"splinecodeurl":"https://cdn.scrollsequence.com/spline/balloons.splinecode"} /-->
                        <!-- /wp:scroll-sequence/v2-scene -->
                        

                    </div>
                    <!-- /wp:group -->

                <?php
            }),
        ]
    );   

    // Canvas 2D + 3D Layered Pattern
    register_block_pattern(
        'scroll-sequence/layered-canvas',
        [
            'title'       => __( 'Scrollsequence Pattern: Canvas 2D + 3D Layered Pattern', 'scrollsequence' ),
            'description' => _x( 
                'Scrollsequence Canvas 2D + 3D Layered Pattern', // text
                'Block pattern description',  // context
                'scrollsequence' // domain
            ),
            'viewportWidth' => 1600, 
            'viewportHeight' => 900, 

            // NO blockTypes here – that’s what keeps it out of the starter popup
            // NO postTypes here either – pattern will be usable in all editors
            
            'categories' => [ 'scroll-sequence' ],
            'content' => scroll_sequence_render_pattern_content(function () {
                ?>
                    <!-- wp:group {"align":"full","style":{"color":{"background":"#f0f2ef"}},"layout":{"type":"default"}} -->
                    <div class="wp-block-group alignfull has-background" style="background-color:#f0f2ef">
                        <!-- wp:scroll-sequence/v2-scene {"duration":1000,"triggerStart":0.98999999999999999,"triggerEnd":0.72999999999999998,"align":"full","layout":{"type":"default"}} -->
                        <!-- wp:scroll-sequence/v2-canvas2d {"width":100,"widthUnit":"%","height":30,"heightUnit":"vh","mediaGroups":[{"type":"urlList","images":["0008.jpeg","0009.jpeg","0010.jpeg","0011.jpeg","0012.jpeg","0013.jpeg","0014.jpeg","0015.jpeg","0016.jpeg","0017.jpeg","0018.jpeg","0019.jpeg","0020.jpeg","0021.jpeg","0022.jpeg","0023.jpeg","0024.jpeg","0025.jpeg","0026.jpeg","0027.jpeg","0028.jpeg","0029.jpeg","0030.jpeg","0031.jpeg","0032.jpeg","0033.jpeg","0034.jpeg","0035.jpeg","0036.jpeg","0037.jpeg","0038.jpeg","0039.jpeg","0040.jpeg","0041.jpeg","0042.jpeg","0043.jpeg","0044.jpeg","0045.jpeg","0046.jpeg","0047.jpeg","0048.jpeg","0049.jpeg","0050.jpeg","0051.jpeg","0052.jpeg","0053.jpeg","0054.jpeg","0055.jpeg","0056.jpeg","0057.jpeg","0058.jpeg","0059.jpeg","0060.jpeg","0061.jpeg","0062.jpeg","0063.jpeg","0064.jpeg","0065.jpeg","0066.jpeg","0067.jpeg","0068.jpeg","0069.jpeg","0070.jpeg","0071.jpeg","0072.jpeg","0073.jpeg","0074.jpeg","0075.jpeg","0076.jpeg","0077.jpeg","0078.jpeg","0079.jpeg","0080.jpeg","0081.jpeg","0082.jpeg","0083.jpeg","0084.jpeg","0085.jpeg","0086.jpeg","0087.jpeg","0088.jpeg","0089.jpeg","0090.jpeg","0091.jpeg","0092.jpeg","0093.jpeg","0094.jpeg","0095.jpeg","0096.jpeg","0097.jpeg","0098.jpeg","0099.jpeg","0100.jpeg","0101.jpeg","0102.jpeg","0103.jpeg","0104.jpeg","0105.jpeg","0106.jpeg","0107.jpeg","0108.jpeg","0109.jpeg","0110.jpeg","0111.jpeg","0112.jpeg","0113.jpeg","0114.jpeg","0115.jpeg","0116.jpeg","0117.jpeg","0118.jpeg","0119.jpeg","0120.jpeg","0121.jpeg","0122.jpeg","0123.jpeg","0124.jpeg","0125.jpeg","0126.jpeg","0127.jpeg","0128.jpeg","0129.jpeg","0130.jpeg","0131.jpeg","0132.jpeg","0133.jpeg","0134.jpeg","0135.jpeg","0136.jpeg","0137.jpeg","0138.jpeg","0139.jpeg","0140.jpeg","0141.jpeg","0142.jpeg","0143.jpeg","0144.jpeg","0145.jpeg","0146.jpeg","0147.jpeg","0148.jpeg","0149.jpeg","0150.jpeg","0151.jpeg","0152.jpeg","0153.jpeg","0154.jpeg","0155.jpeg","0156.jpeg","0157.jpeg","0158.jpeg","0159.jpeg","0160.jpeg","0161.jpeg","0162.jpeg","0163.jpeg","0164.jpeg","0165.jpeg","0166.jpeg","0167.jpeg","0168.jpeg","0169.jpeg","0170.jpeg","0171.jpeg","0172.jpeg","0173.jpeg","0174.jpeg","0175.jpeg","0176.jpeg","0177.jpeg","0178.jpeg","0179.jpeg","0180.jpeg","0181.jpeg","0182.jpeg","0183.jpeg","0184.jpeg","0185.jpeg","0186.jpeg","0187.jpeg","0188.jpeg","0189.jpeg","0190.jpeg","0191.jpeg","0192.jpeg","0193.jpeg","0194.jpeg","0195.jpeg","0196.jpeg","0197.jpeg","0198.jpeg","0199.jpeg","0200.jpeg","0201.jpeg","0202.jpeg","0203.jpeg","0204.jpeg","0205.jpeg","0206.jpeg","0207.jpeg","0208.jpeg","0209.jpeg","0210.jpeg","0211.jpeg","0212.jpeg","0213.jpeg","0214.jpeg","0215.jpeg","0216.jpeg","0217.jpeg","0218.jpeg","0219.jpeg","0220.jpeg","0221.jpeg","0222.jpeg","0223.jpeg","0224.jpeg","0225.jpeg","0226.jpeg","0227.jpeg","0228.jpeg","0229.jpeg","0230.jpeg","0231.jpeg","0232.jpeg","0233.jpeg","0234.jpeg","0235.jpeg","0236.jpeg","0237.jpeg","0238.jpeg","0239.jpeg","0240.jpeg","0241.jpeg"],"duration":1,"bgSize":"contain","bgPosition":{"x":0.5,"y":1},"prefix":"https://cdn.scrollsequence.com/v2-two-robots/","suffix":""}],"triggerStart":0.75,"triggerEnd":0.75,"ssqSceneAlign":"bottom center"} /-->

                        <!-- wp:scroll-sequence/v2-canvas3d {"width":100,"height":100,"splinecodeurl":"http://cdn.scrollsequence.com/spline/logo-blue-robots.splinecode","style":{"spacing":{"margin":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"ssqSceneAlign":"center center"} /-->

                        <!-- wp:heading {"className":"is-style-default","style":{"spacing":{"margin":{"top":"87px","bottom":"0px"}}},"fontSize":"x-large","ssqAnimateOnLoad":{"to":{"keyframes":{"0%":{"y":0},"100%":{"y":15}},"duration":2,"repeat":-1,"yoyo":true}},"ssqSceneAlign":"top center"} -->
                        <h2 class="wp-block-heading is-style-default has-x-large-font-size" style="margin-top:87px;margin-bottom:0px">Join us on Alpha Testing</h2>
                        <!-- /wp:heading -->
                        <!-- /wp:scroll-sequence/v2-scene -->
                    </div>
                    <!-- /wp:group -->
                <?php
            }),
        ]
    );   


    // Canvas Muud
    register_block_pattern(
        'scroll-sequence/muud',
        [
            'title'       => __( 'Scrollsequence Pattern: Muud', 'scrollsequence' ),
            'description' => _x( 
                'Scrollsequence Muud', // text
                'Block pattern description',  // context
                'scrollsequence' // domain
            ),
            'viewportWidth' => 1600, 
            'viewportHeight' => 900, 

            'blockTypes' => [ 'core/post-content' ],                    // YES - this turns on the pattern only for starter patterns
            'postTypes' => scroll_sequence_get_starter_post_types(),    // YES - get post types that use block editor so that it is set for starter patterns explicitly

            'categories' => [ 'scroll-sequence' ],
            'content' => scroll_sequence_render_pattern_content(function () {
                ?>
                    <!-- wp:group {"align":"full","layout":{"type":"default"}} -->
                    <div class="wp-block-group alignfull">
                        <!-- wp:scroll-sequence/v2-scene {"duration":3000, "align":"full","layout":{"type":"default"}} -->
                            <!-- wp:scroll-sequence/v2-canvas2d {"height":100,"heightUnit":"vh","mediaGroups":[{"type":"urlList","images":["muudz-0001.jpg","muudz-0002.jpg","muudz-0004.jpg","muudz-0005.jpg","muudz-0007.jpg","muudz-0008.jpg","muudz-0010.jpg","muudz-0011.jpg","muudz-0013.jpg","muudz-0014.jpg","muudz-0016.jpg","muudz-0017.jpg","muudz-0019.jpg","muudz-0020.jpg","muudz-0022.jpg","muudz-0023.jpg","muudz-0025.jpg","muudz-0026.jpg","muudz-0028.jpg","muudz-0029.jpg","muudz-0031.jpg","muudz-0032.jpg","muudz-0034.jpg","muudz-0035.jpg","muudz-0037.jpg","muudz-0038.jpg","muudz-0040.jpg","muudz-0041.jpg","muudz-0043.jpg","muudz-0044.jpg","muudz-0046.jpg","muudz-0047.jpg","muudz-0049.jpg","muudz-0050.jpg","muudz-0052.jpg","muudz-0053.jpg","muudz-0055.jpg","muudz-0056.jpg","muudz-0058.jpg","muudz-0059.jpg","muudz-0061.jpg","muudz-0062.jpg","muudz-0064.jpg","muudz-0065.jpg","muudz-0067.jpg","muudz-0068.jpg","muudz-0070.jpg","muudz-0071.jpg","muudz-0073.jpg","muudz-0074.jpg","muudz-0076.jpg","muudz-0077.jpg","muudz-0079.jpg","muudz-0080.jpg","muudz-0082.jpg","muudz-0083.jpg","muudz-0085.jpg","muudz-0086.jpg","muudz-0088.jpg","muudz-0089.jpg","muudz-0091.jpg","muudz-0092.jpg","muudz-0094.jpg","muudz-0095.jpg","muudz-0097.jpg","muudz-0098.jpg","muudz-0100.jpg","muudz-0102.jpg","muudz-0104.jpg","muudz-0105.jpg","muudz-0107.jpg","muudz-0108.jpg","muudz-0110.jpg","muudz-0111.jpg","muudz-0113.jpg","muudz-0114.jpg","muudz-0116.jpg","muudz-0117.jpg","muudz-0119.jpg","muudz-0120.jpg","muudz-0122.jpg","muudz-0123.jpg","muudz-0125.jpg","muudz-0126.jpg","muudz-0128.jpg","muudz-0129.jpg","muudz-0131.jpg","muudz-0132.jpg","muudz-0134.jpg","muudz-0135.jpg","muudz-0137.jpg","muudz-0138.jpg","muudz-0140.jpg","muudz-0141.jpg"],"duration":1,"bgSize":"cover","bgPosition":{"x":0.5,"y":0.5},"prefix":"https://cdn.scrollsequence.com/v2-muud/"},{"type":"urlList","images":["muudzoomout-0001.jpeg","muudzoomout-0002.jpeg","muudzoomout-0004.jpeg","muudzoomout-0005.jpeg","muudzoomout-0007.jpeg","muudzoomout-0008.jpeg","muudzoomout-0010.jpeg","muudzoomout-0011.jpeg","muudzoomout-0013.jpeg","muudzoomout-0014.jpeg","muudzoomout-0016.jpeg","muudzoomout-0017.jpeg","muudzoomout-0019.jpeg","muudzoomout-0020.jpeg","muudzoomout-0022.jpeg","muudzoomout-0023.jpeg","muudzoomout-0025.jpeg","muudzoomout-0026.jpeg","muudzoomout-0028.jpeg","muudzoomout-0029.jpeg","muudzoomout-0031.jpeg","muudzoomout-0032.jpeg","muudzoomout-0034.jpeg","muudzoomout-0035.jpeg","muudzoomout-0037.jpeg","muudzoomout-0038.jpeg","muudzoomout-0040.jpeg","muudzoomout-0041.jpeg","muudzoomout-0043.jpeg","muudzoomout-0044.jpeg","muudzoomout-0046.jpeg","muudzoomout-0047.jpeg","muudzoomout-0049.jpeg","muudzoomout-0050.jpeg","muudzoomout-0052.jpeg","muudzoomout-0053.jpeg","muudzoomout-0055.jpeg","muudzoomout-0056.jpeg","muudzoomout-0058.jpeg","muudzoomout-0059.jpeg","muudzoomout-0061.jpeg","muudzoomout-0062.jpeg","muudzoomout-0064.jpeg","muudzoomout-0065.jpeg","muudzoomout-0067.jpeg","muudzoomout-0068.jpeg","muudzoomout-0070.jpeg","muudzoomout-0071.jpeg","muudzoomout-0073.jpeg","muudzoomout-0074.jpeg","muudzoomout-0076.jpeg","muudzoomout-0077.jpeg","muudzoomout-0079.jpeg","muudzoomout-0080.jpeg","muudzoomout-0082.jpeg","muudzoomout-0083.jpeg","muudzoomout-0085.jpeg","muudzoomout-0086.jpeg","muudzoomout-0088.jpeg","muudzoomout-0089.jpeg","muudzoomout-0091.jpeg","muudzoomout-0092.jpeg","muudzoomout-0094.jpeg","muudzoomout-0095.jpeg","muudzoomout-0097.jpeg","muudzoomout-0098.jpeg","muudzoomout-0100.jpeg","muudzoomout-0102.jpeg","muudzoomout-0104.jpeg","muudzoomout-0105.jpeg","muudzoomout-0107.jpeg","muudzoomout-0108.jpeg","muudzoomout-0110.jpeg","muudzoomout-0111.jpeg","muudzoomout-0113.jpeg","muudzoomout-0114.jpeg","muudzoomout-0116.jpeg","muudzoomout-0117.jpeg","muudzoomout-0119.jpeg","muudzoomout-0120.jpeg","muudzoomout-0122.jpeg","muudzoomout-0123.jpeg","muudzoomout-0125.jpeg","muudzoomout-0126.jpeg","muudzoomout-0128.jpeg","muudzoomout-0129.jpeg","muudzoomout-0131.jpeg","muudzoomout-0132.jpeg","muudzoomout-0134.jpeg","muudzoomout-0135.jpeg","muudzoomout-0137.jpeg","muudzoomout-0138.jpeg","muudzoomout-0140.jpeg","muudzoomout-0141.jpeg"],"duration":1,"bgSize":"cover","bgPosition":{"x":0.5,"y":0.5},"prefix":"https://cdn.scrollsequence.com/v2-muud/"}],"triggerStart":0.69} /-->

                            <!-- wp:group {"style":{"dimensions":{"minHeight":""}},"layout":{"type":"constrained"},"ssqAnimateOnScroll":{"to":{"keyframes":{"0%":{"y":-100,"filter":"blur(40px)","scale":0.1,"autoAlpha":0},"50%":{"y":0,"filter":"blur(0px)","scale":1,"autoAlpha":1},"60%":{"y":0,"autoAlpha":1},"65%":{"scale":0.9},"85%":{"autoAlpha":0,"filter":"blur(40px)","scale":0,"x":-10,"y":-80},"easeEach":"expo.inOut"},"ease":"none","duration":2}}} -->
                            <div class="wp-block-group"><!-- wp:heading {"textAlign":"center","style":{"color":{"text":"#faf7f2"},"elements":{"link":{"color":{"text":"#faf7f2"}}}},"fontSize":"xx-large"} -->
                            <h2 class="wp-block-heading has-text-align-center has-text-color has-link-color has-xx-large-font-size" style="color:#faf7f2">MUUD</h2>
                            <!-- /wp:heading -->

                            <!-- wp:paragraph {"align":"center","style":{"color":{"text":"#faf7f2"},"elements":{"link":{"color":{"text":"#faf7f2"}}}}} -->
                            <p class="has-text-align-center has-text-color has-link-color" style="color:#faf7f2">YERBA MATE </p>
                            <!-- /wp:paragraph -->

                            <!-- wp:paragraph {"align":"center","style":{"color":{"text":"#faf7f2"},"elements":{"link":{"color":{"text":"#faf7f2"}}}}} -->
                            <p class="has-text-align-center has-text-color has-link-color" style="color:#faf7f2">Find Your Inner Balance</p>
                            <!-- /wp:paragraph -->

                            <!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
                            <div class="wp-block-buttons"><!-- wp:button {"textAlign":"center","style":{"color":{"background":"#d19a30"}},"fontSize":"large","ssqAnimateOnHover":{"to":{"keyframes":{"0%":{"x":0,"y":0},"25%":{"x":3,"y":-3},"50%":{"x":-5,"y":5},"75%":{"x":4,"y":-4},"100%":{"x":0,"y":0}},"ease":"sine.inOut","duration":0.5,"yoyo":true,"repeat":1}}} -->
                            <div class="wp-block-button"><a class="wp-block-button__link has-background has-large-font-size has-text-align-center has-custom-font-size wp-element-button" style="background-color:#d19a30"><strong>SHOP NOW</strong></a></div>
                            <!-- /wp:button --></div>
                            <!-- /wp:buttons --></div>
                            <!-- /wp:group -->
                        <!-- /wp:scroll-sequence/v2-scene -->
                    </div>
                    <!-- /wp:group -->
                <?php
            }),
        ]
    );   


}

add_action( 'init', 'scroll_sequence_register_v2_patterns' );





    // Pattern 001: Hero with text and button
    /*
    register_block_pattern(
        'scroll-sequence/pattern-001',
        array(
            'title'       => __( 'Scrollsequence Pattern 001', 'scrollsequence' ),
            'description' => _x( 
                'Two horizontal buttons, the left button is filled in, and the right button is outlined.', // text
                'Block pattern description',  // context
                'scrollsequence' // domain
            ),
            'blockTypes' => array( 'core/post-content' ), // starter patterns only
            'postTypes' => array( 'scroll-sequence' ), // starter patterns only
            'categories' => array( 'scroll-sequence' ),
            'content' => scroll_sequence_render_pattern_content(function () {
                ?>
                    <!-- wp:paragraph -->
                    <p>Pattern 001</p>
                    <!-- /wp:paragraph -->

                    <!-- wp:heading -->
                    <h2 class="wp-block-heading">Pattern 001 Head!</h2>
                    <!-- /wp:heading -->

                    <!-- wp:buttons -->
                    <div class="wp-block-buttons">
                        <!-- wp:button -->
                        <div class="wp-block-button"><a class="wp-block-button__link wp-element-button">Button Shady!</a></div>
                        <!-- /wp:button -->
                    </div>
                    <!-- /wp:buttons -->
                <?php
            }),
        )
    );
    */


