<?php 
/**
 * HELPER FUNCTIONS 
 */
function ssq_get_dim_with_unit($atts,$keyname){ // get dimension with unit example "100vh"
    return esc_html( $atts[$keyname] ) . esc_html( $atts[$keyname.'Unit'] );
}
/**
 * 
 * MAIN VARIATION RENDER FUNCTION
 * 
 */
function ssq_render_scene_variation($atts){
    // Sticky CSS and JS
    if ($atts['scenePosition']==='sticky'){
        if($atts['stickyType']==='css'){
            if($atts['sendBehindContent'] === false){
                if($atts['stickySpacing'] === true){
                    return ssq_sticky_css_fg_spacing($atts); // OK - 0
                }
                if($atts['stickySpacing'] === false){
                    return ssq_sticky_css_fg_nospacing($atts); // OK - 0.5
                }
            }
            if($atts['sendBehindContent'] === true){
                if($atts['stickySpacing'] === true){
                    return ssq_sticky_css_bg($atts); // OK - bg2     // sticky spacing does not matter when sendBehindContent is true ??
                }
                if($atts['stickySpacing'] === false){ 
                    return ssq_sticky_css_bg($atts); // OK - bg2     // sticky spacing does not matter when sendBehindContent is true ??
                }
            }            
        }
        if($atts['stickyType']==='js'){
            if($atts['sendBehindContent'] === false){
                if($atts['stickySpacing'] === true){
                    return ssq_sticky_js_fg_spacing($atts); // OK - 1
                }
                if($atts['stickySpacing'] === false){
                    return ssq_sticky_js_fg_nospacing($atts); // OK - 2
                }
            }
            if($atts['sendBehindContent'] === true){
                if($atts['stickySpacing'] === true){
                    return ssq_sticky_js_bg($atts); // bg3             // spacing should not matter when sendBehindContent is true ??
                }
                if($atts['stickySpacing'] === false){
                    return ssq_sticky_js_bg($atts); // bg3             // spacing should not matter when sendBehindContent is true ??
                }
            }       
        }
    }
    // Fixed JS
    if ($atts['scenePosition']==='fixed'){
        if($atts['sendBehindContent'] === false){
            return ssq_fixed_fg($atts); // OK - 3
        }
        if($atts['sendBehindContent'] === true){
            return ssq_fixed_bg($atts); // OK - bg1
        }
    }

    // FAIL if none of the above is true
    return [
        'before' => '<div>Error: Fail to render Scrollsequence Scene ',
        'after' => '</div>',
    ];    

}

function ssq_sticky_css_fg_spacing($atts){ // 0
    $extra_attributes = [
        'class' => 'ssq-not-hydrated ssq-relative', //  ssq-border-green
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' + '.ssq_get_dim_with_unit($atts, 'duration').' );',
    ];
    $extra_mid_attributes = [];
    $extra_inner_attributes = [
        'class' => 'scroll-sequence-v2-scene_inner ssq-sticky', //  ssq-border-green-dashed
        'style' => 'height:'.ssq_get_dim_with_unit($atts, 'height').'; top:'.ssq_get_dim_with_unit($atts, 'top').'; width:100%;', // new 2025-04-10 - add elsewhere too?
    ];
    // unset($atts['minHeight']);       unset($atts['minHeightUnit']);
    return [
        'before' => ssq_v2_render_before( $atts, $extra_attributes, $extra_mid_attributes, $extra_inner_attributes),
        'after' => ssq_v2_render_after( $extra_mid_attributes, $extra_inner_attributes ),
    ];
}

function ssq_sticky_css_bg($atts){ // bg - 2, similar to 0
    $extra_attributes = [ // same for "2/3 bg"?
        'class' => 'ssq-not-hydrated ssq-absolute ssq-pointer-events-none', //  ssq-border-purple
        'style' => 'left:0; right:0; top:'.ssq_get_dim_with_unit($atts, 'absTop').';',
    ];
    $extra_mid_attributes = [
        'class' => 'ssq-relative', //  ssq-border-green
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' + '.ssq_get_dim_with_unit($atts, 'duration').' );',
    ];
    $extra_inner_attributes = [
        'class' => 'scroll-sequence-v2-scene_inner ssq-sticky', //  ssq-border-green-dashed
        'style' => 'height:'.ssq_get_dim_with_unit($atts, 'height').'; top:'.ssq_get_dim_with_unit($atts, 'top').';', 
    ];
    // unset($atts['minHeight']);       unset($atts['minHeightUnit']);
    return [
        'before' => ssq_v2_render_before( $atts, $extra_attributes, $extra_mid_attributes, $extra_inner_attributes),
        'after' => ssq_v2_render_after( $extra_mid_attributes, $extra_inner_attributes ),
    ];
}

function ssq_sticky_css_fg_nospacing($atts){ // 0.5
    $extra_attributes = [
        'class' => 'ssq-not-hydrated ssq-relative', //  ssq-border-green
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' );',
    ];
    $extra_mid_attributes = [
        'class' => 'scroll-sequence-v2-scene_mid ssq-absolute ssq-pointer-events-none', //  ssq-border-purple
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' + '.ssq_get_dim_with_unit($atts, 'duration').' ); inset: 0;', // !!! Not sure about the inset
    ];
    $extra_inner_attributes = [
        'class' => 'scroll-sequence-v2-scene_inner ssq-sticky ssq-pointer-events-auto', //  ssq-border-green-dashed
        'style' => 'height:'.ssq_get_dim_with_unit($atts, 'height').'; top:'.ssq_get_dim_with_unit($atts, 'top').';', 
    ];
    // unset($atts['minHeight']);       unset($atts['minHeightUnit']);
    return [
        'before' => ssq_v2_render_before( $atts, $extra_attributes, $extra_mid_attributes, $extra_inner_attributes),
        'after' => ssq_v2_render_after( $extra_mid_attributes, $extra_inner_attributes ),
    ];
}



function ssq_sticky_js_fg_spacing($atts){ // 1
    // HERE I ASSUME PREMIUM .... 
    $extra_attributes = [
        'class' => 'ssq-not-hydrated ssq-relative', //  ssq-border-green
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' + '.ssq_get_dim_with_unit($atts, 'duration').' );',
    ];    
    $extra_mid_attributes = []; 
    $extra_inner_attributes = [
        'class' => 'scroll-sequence-v2-scene_inner', //  ssq-border-green-dashed
        'style' => 'height:'.ssq_get_dim_with_unit($atts, 'height').';', 
    ];
    return [
        'before' => ssq_v2_render_before( $atts, $extra_attributes, $extra_mid_attributes, $extra_inner_attributes),
        'after' => ssq_v2_render_after( $extra_mid_attributes, $extra_inner_attributes ),
    ];
}
function ssq_sticky_js_fg_nospacing($atts){ // 2
    $extra_attributes = [
        'class' => 'ssq-not-hydrated ssq-relative', //  ssq-border-green
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' );'//, 
    ];    
    $extra_mid_attributes = []; 
    $extra_inner_attributes = [];
    return [
        'before' => ssq_v2_render_before( $atts, $extra_attributes, $extra_mid_attributes, $extra_inner_attributes),
        'after' => ssq_v2_render_after( $extra_mid_attributes, $extra_inner_attributes ),
    ];
}

function ssq_sticky_js_bg($atts){ // bg3 - similar to 2
    $extra_attributes = [ 
        'class' => 'ssq-not-hydrated ssq-absolute ssq-pointer-events-none', //  ssq-border-purple
        'style' => 'left:0; width:100%; top:'.ssq_get_dim_with_unit($atts, 'absTop').';', // here I have put width instead of right:0 to make the pin-spacer work.
    ];    
    $extra_mid_attributes = []; 
    $extra_inner_attributes = [
        'class' => ' scroll-sequence-v2-scene_inner ssq-relative', //  ssq-border-green
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' );'
    ];
    return [
        'before' => ssq_v2_render_before( $atts, $extra_attributes, $extra_mid_attributes, $extra_inner_attributes),
        'after' => ssq_v2_render_after( $extra_mid_attributes, $extra_inner_attributes ),
    ];
}

function ssq_fixed_fg($atts){
    $extra_attributes = [
        'class' => 'ssq-not-hydrated ssq-relative', //  ssq-border-green
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' + '.ssq_get_dim_with_unit($atts, 'duration').' );',
    ];
    $extra_mid_attributes = [];
    $extra_inner_attributes = [
        'class' => 'scroll-sequence-v2-scene_inner ssq-fixed', //  ssq-border-green-dashed
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' );  inset:0; top:'.ssq_get_dim_with_unit($atts, 'top').';', // 
    ];
    // unset($atts['minHeight']);  unset($atts['minHeightUnit']);
    return [
        'before' => ssq_v2_render_before( $atts, $extra_attributes, $extra_mid_attributes, $extra_inner_attributes),
        'after' => ssq_v2_render_after( $extra_mid_attributes, $extra_inner_attributes ),
    ];
}

function ssq_fixed_bg($atts){ // bg1
    $extra_attributes = [ // same for "2/3 bg"? 
        'class' => 'ssq-not-hydrated ssq-absolute ssq-pointer-events-none', //  ssq-border-purple
        'style' => 'left:0; right:0; top:'.ssq_get_dim_with_unit($atts, 'absTop').';',
    ];
    $extra_mid_attributes = [
        'class' => 'scroll-sequence-v2-scene_mid ssq-relative', //   ssq-border-green
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' + '.ssq_get_dim_with_unit($atts, 'duration').' );',
    ];
    $extra_inner_attributes = [
        'class' => 'scroll-sequence-v2-scene_inner ssq-fixed', //  ssq-border-green-dashed
        'style' => 'height: calc( '.ssq_get_dim_with_unit($atts, 'height').' );  inset:0; top:'.ssq_get_dim_with_unit($atts, 'top').';', // 
    ];
    // unset($atts['minHeight']);  unset($atts['minHeightUnit']);
    return [
        'before' => ssq_v2_render_before( $atts, $extra_attributes, $extra_mid_attributes, $extra_inner_attributes),
        'after' => ssq_v2_render_after( $extra_mid_attributes, $extra_inner_attributes ),
    ];
}

function ssq_v2_render_before( $atts, $extra_attributes, $extra_mid_attributes, $extra_inner_attributes){
    
    ob_start();?>
        <div 
            <?php echo wp_kses_data( get_block_wrapper_attributes($extra_attributes) ); ?>  
            data-ssq-scene='<?php echo wp_json_encode($atts);?>' 
        >

            <?php if (isset($extra_mid_attributes) && !empty($extra_mid_attributes)){?>
            <div 
                class="<?php echo esc_attr( $extra_mid_attributes['class'] ) ?>"  
                style="<?php echo esc_attr( $extra_mid_attributes['style'] ) ?>"  
            >
            <?php } ?>

                <?php if (isset($extra_inner_attributes) && !empty($extra_inner_attributes)){?>
                <div 
                    class="<?php echo esc_attr( $extra_inner_attributes['class'] ) ?>"
                    style="<?php echo esc_attr( $extra_inner_attributes['style'] ) ?>" 
                >
                <?php } ?>
    <?php 
    return ob_get_clean();        
}
function ssq_v2_render_after( $extra_mid_attributes, $extra_inner_attributes ){
    ob_start();?>

                <?php if (isset($extra_inner_attributes) && !empty($extra_inner_attributes)){?>
                </div>
                <?php } ?>

            <?php if (isset($extra_mid_attributes) && !empty($extra_mid_attributes)){?>
            </div>
            <?php } ?>
        </div>
    <?php 
    return ob_get_clean();        
}
















// CONTENT 
/*
    This function will do the first level of scene alignment and wrap each inner block content into a div
*/
function ssq_get_wrapped_content( $block ) {
    // see: https://github.com/WordPress/gutenberg/issues/7247 (for info about this function)
    // see: to understand the "weird for loop" https://developer.wordpress.org/reference/classes/wp_block_list/
    // Check if inner block are defined 
    if ( ! isset( $block->inner_blocks ) ) {
        return '';
    }
    if ( empty( $block->inner_blocks ) ) {
        return '';
    }   
	// Check how many inner blocks are available
	$item_count = $block->inner_blocks->count();

	if ( $item_count < 1 ) {
		return '';
	}
	
	ob_start();
        // iterate over the available inner blocks
        for ( $index = 1; $index <= $item_count; $index++ ) :

            // Get the inner block data
            $inner_block = $block->inner_blocks->current(); 
            
            // Holds the inner block attribute
            $iattribute   = $inner_block->attributes;

            $align_class = '';

            if ( isset( $iattribute['ssqSceneAlign'] ) ) {
                $align_class .= ' ssq-hoc-scene-' . esc_attr(  str_replace(" ", "-", $iattribute['ssqSceneAlign']) );
            } else {
                $align_class .= ' ssq-hoc-scene-center-center';
            }

            // This will render the inner block content
            echo PHP_EOL.'<div class="ssq-absolute ssq-inset ssq-flex ssq-pointer-events-none ssq-pointer-events-child-auto '.esc_attr($align_class).'" >'.trim($inner_block->render()).'</div>'.PHP_EOL;

            // increase the index in the WP_Block_List class used to retrieve the current block
            $block->inner_blocks->next();
        endfor;
            // reset the index in the WP_Block_List class to the initial state
            $block->inner_blocks->rewind();

	return ob_get_clean();
}