<?php
/**
 * PHP file to use when rendering the block type on the server to show on the front end.
 *
 * The following variables are exposed to the file:
 *     $attributes (array): The block attributes.
 *     $content (string): The block default content.
 *     $block (WP_Block): The block instance.
 *
 * @see https://github.com/WordPress/gutenberg/blob/trunk/docs/reference-guides/block-api/block-metadata.md#render
 */

$minHeight = isset($attributes['minHeight']) ? $attributes['minHeight'] : '';
$minHeightUnit = isset($attributes['minHeightUnit']) ? $attributes['minHeightUnit'] : 'px';
$minHeightWithUnit = $minHeight . $minHeightUnit;

// Initialize extra attributes for the wrapper div
$scroll_sequence_extra_attributes = [
    'class' => 'ssq-not-hydrated ssq-relative',
    'style' => 'overflow-x: clip;' . ( $minHeight !== '' ? ' min-height:' . esc_attr( $minHeightWithUnit ) . ';' : '' ),
];

?>

<div 
    <?php echo wp_kses_data( get_block_wrapper_attributes($scroll_sequence_extra_attributes) ); ?>  
    data-ssq-container='<?php echo wp_json_encode($attributes);?>' 
>
    <?php echo $content; // Something says to me, this should be escaped.  ?>
    <?php //echo esc_html( $content ); // Escape the content to prevent XSS  ?>
</div>

