//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Notice, Button } from '@wordpress/components';

declare const wp: any;
declare const scroll_sequence_editor_data: any;
const { applyFilters } = wp.hooks;

export default function TabDashboard() {
    return (
        <div >

            {/* Free 14 days trial CTA section */}
            {['free', 'PLAN_NAME'].includes(scroll_sequence_editor_data.current_plan) && !Boolean(Number(scroll_sequence_editor_data.isTrial) ) && (
                <div
                    style={{
                        maxWidth: '800px',
                        marginBottom: '1.5em',
                        marginTop: '1.5em',
                        padding: '1.5em',
                        background: '#e9ebf7ff',
                        borderRadius: '8px',
                        border: '1px solid #c3c5e6ff',
                    }}
                >
                    <h2 style={{ marginTop: 0 }}>🎉 Try Scrollsequence Pro for Free!</h2>
                    <p>
                        Unlock the full potential of Scrollsequence with a 14-day free trial of the Pro version.
                        Experience advanced features, AI-powered tools, and premium support to elevate your projects.
                    </p>

                    <Button
                        isPrimary
                        icon="tickets"
                        onClick={() => window.open(`${scroll_sequence_editor_data.adminUrl}admin.php?page=scrollsequence-dashboard-pricing&trial=true`, '_blank')}
                    >
                        Start Free Trial
                    </Button>
                </div>
            )}
 

            {/* Hero / Intro Section */}
            <div
                style={{
                    maxWidth: '800px',
                    marginBottom: '1.5em',
                    marginTop: '1.5em',
                    padding: '1.5em',
                    background: '#f8f9fa',
                    borderRadius: '8px',
                    border: '1px solid #e2e3e5',
                }}
            >
                <h2 style={{ marginTop: 0 }}>🚀 Scrollsequence v2 is still in development</h2>
                {/* <p>
                    Thanks for testing <strong>Scrollsequence v2</strong> and helping us build the next generation of interactive WordPress sites.
                    Your feedback directly shapes the future of this plugin.
                </p> */}
                <p>
                    Scrollsequence is a passion project, and even though it has been 5 years, the v2 plugin still needs more time to be fully complete.
                </p>
                <p>
                    Certain features aren't available yet, and some existing ones may be unstable or incomplete. You might encounter bugs or unexpected behavior.
                    Feel free to drop feedback using the button on the bottom right of the plugin interface or join our
                    {` `} 
                    <a href="https://join.slack.com/t/scrollsequence/shared_invite/zt-zf0we93n-vRZmTdO4VkPL17vYXGS2OA" target='_blank'>Slack</a> community, where I try to respond every day.
                </p>
                <p>
                    Thank you for your understanding as I continue to work on the plugin.
                </p>
                <p>
                    <strong>Please don't use this version on production sites.</strong>
                    <br/>
                    This is an beta version — features may change, break, or be removed at any time.
                    If you decide to use it on a live site, please ensure to turn auto updates off to avoid unexpected changes. 
                    Also check <a href="https://docs.scrollsequence.com/v2/roadmap">Changelog</a> for breaking changes when updating the plugin.
                </p>
                <p style={{ fontStyle: 'italic', marginBottom: 0 }}>Ales, Scrollsequence Founder</p>
            </div>

            {/* Quick Start Instructions */}
            <div
                style={{
                    maxWidth: '800px',
                    marginBottom: '1.5em',
                    padding: '1.5em',
                    background: '#ffffff',
                    borderRadius: '8px',
                    border: '1px solid #e2e3e5',
                }}
            >
                <h3 style={{ marginTop: 0 }}>✅ Quick Start</h3>
                <p>Simply create a <strong>New Scrollsequence</strong> and select a pattern and immediately you can see an example scroll animation (great starting point).</p>
                <ul>
                    {/* <li>
                        <strong>Create a New Scrollsequence:</strong> Wait for the pop-up and choose a pattern (great starting point).
                    </li> */}
                    <li>
                        <strong>Canvas 2D:</strong> Add Canvas 2D block. In the placeholder you can use existing image sequences, use your own media, or generate new media using AI Media Tools.
                    </li>
                    <li>
                        <strong> Canvas 2D Media Tools: </strong> Media tools are accessible via the Canvas 2D. They allow you to generate images, videos and sequences using AI models directly within the block editor.
                    </li>
                    <li>
                        <strong>Canvas 3D:</strong> Add a 3D block → pick from premade objects or link your Spline project → scroll to animate.
                    </li>
                    <li>
                        <strong>Content Animation:</strong> Place blocks inside a <em>Container</em> block → animate them manually or use AI to generate synced animations.
                    </li>
                    <li>
                        <strong>License Key:</strong> Customers who previously bought a license can use it in v2. Free Trial key is valid for 14 days. Provide feedback → we'll extend it for 30-90 days.
                    </li>     
                    <li>
                        <strong>AI Credits:</strong> Free and Trial accounts have 100 AI credits to experiment with media generation and animation generation. Pro accounts have 1000 credits each 30 days, Business accounts have 3000 credits each 30 days.
                    </li>               
                </ul>
            </div>


            <div
                style={{
                    maxWidth: '800px',
                    marginBottom: '1.5em',
                    marginTop: '1.5em',
                    padding: '1.5em',
                    background: '#f8f9fa',
                    borderRadius: '8px',
                    border: '1px solid #e2e3e5',
                }}
            >
                <h2 style={{ marginTop: 0 }}>Tutorial Video </h2>
                <iframe 
                width="560" height="315" src="https://www.youtube.com/embed/h3X7qzOmKbQ?si=o48TPTp5FO9bLIUQ" title="YouTube video player" 
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerPolicy="strict-origin-when-cross-origin" allowFullScreen>
                </iframe>
            </div>


            {/* AI Credits */}
            {/* <div
                style={{
                    maxWidth: '800px',
                    marginBottom: '1.5em',
                    padding: '1.5em',
                    background: '#f8f9fa',
                    borderRadius: '8px',
                    border: '1px solid #e2e3e5',
                }}
            >
                <h3 style={{ marginTop: 0 }}>🤖 AI Credits</h3>
                <ul>
                    <li>
                        Currently the AI Credits are non-restrictive, even if you run out, you can still use the media tools. 
                    </li>
                    <li>
                        Video generation is expensive → please don't over-use it.
                    </li>
                </ul>
            </div> */}

            {/* What to Test */}
            <div
                style={{
                    maxWidth: '800px',
                    marginBottom: '1.5em',
                    padding: '1.5em',
                    background: '#ffffff',
                    borderRadius: '8px',
                    border: '1px solid #e2e3e5',
                }}
            >
                <h3 style={{ marginTop: 0 }}>🧪 What to Test</h3>
                <ul>
                    <li>✅ Canvas 2D & 3D Blocks</li>
                    <li>✅ Canvas 2D - Media Tools </li>
                    <li>✅ Block & Animation Generation</li>
                    <li>✅ Container Block</li>
                    <li>✅ Scene Block</li>

                    {/* <li>❌ Canvas 1D (not functional yet)</li> */}
                    <li>❌ Mobile optimization (still in progress)</li>
                    <li>❌ Direct video scroll animation (use image sequences instead)</li>
                </ul>
            </div>

            {/* Feedback */}
            <div
                style={{
                    maxWidth: '800px',
                    marginBottom: '1.5em',
                    padding: '1.5em',
                    background: '#f8f9fa',
                    borderRadius: '8px',
                    border: '1px solid #e2e3e5',
                }}
            >
                <h3 style={{ marginTop: 0 }}>💬 Feedback = Gold</h3>
                <p>
                    Use the <strong>Feedback button</strong> (bottom right in the plugin), or ping us on <a href="https://join.slack.com/t/scrollsequence/shared_invite/zt-zf0we93n-vRZmTdO4VkPL17vYXGS2OA" target='_blank'>Slack</a>.
                    Active testers get extended licenses & more AI credits.
                </p>
            </div>










        </div>
    );
}