//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Draggable, Panel, PanelBody, DropZone } from '@wordpress/components';
import { Icon, more } from '@wordpress/icons';

import { useState, Fragment, useEffect } from 'react';

import JobTables from './JobTables';

declare const scroll_sequence_editor_data :any

export default function TabApi(){
    const [ someData, setSomeData ] = useState([]);
    const [ someError, setSomeError ] = useState<any>(false);
    const [ loading, setLoading ] = useState<boolean>(true);

    useEffect(() => {
        const fetchJobs = async () => {
            setLoading(true);
            try {
                const response = await fetch(`${scroll_sequence_editor_data.scrollSequenceApiUrl}/v2/jobs`, {
                    method: 'GET',
                    headers: {
                        'Authorization': `${scroll_sequence_editor_data.fs_auth_hash}`,
                        'Content-Type': 'application/json',
                    },
                });
    
                const data = await response.json();
    
                if (!response.ok) {
                    // Handle API errors with a consistent format
                    const errorDetails = data?.error || { message: 'Unknown error occurred.' };
                    console.log('errorDetails____', errorDetails);
                    setSomeError({
                        status: response.status,
                        message: errorDetails || response.statusText,
                        details: errorDetails || null,
                    });
                    console.error('API Error:', errorDetails);
                    setLoading(false);
                    return;
                }
    
                // Handle successful response
                setSomeData(data);
                setSomeError(false);
                setLoading(false);
                console.log('Fetched data:', data);
            } catch (error: any) {
                // Handle network or unexpected errors
                setSomeError({
                    message: error.message || 'An unexpected error occurred.',
                    stack: error.stack || null,
                });
                setLoading(false);
                console.error('Error fetching data:', error);
            }
        };
    
        fetchJobs();
    }, []);



    return(
        <>
            <h2>History <span style={{color:"gray"}}> (scope: site_id) </span></h2>
            {someError && <pre>{JSON.stringify(someError, null,2)}</pre> }
            <JobTables jobsData={someData} loading={loading} />
            {
                /*
                <h2>Raw Jobs Data</h2>
                <pre>{JSON.stringify(someData, null,2)}</pre>
                */
            }
            <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                <span
                    style={{
                        fontSize: '10px',
                        color: '#bbb',
                        opacity: 0.7,
                        pointerEvents: 'none',
                        userSelect: 'none',
                    }}
                >
                   API:{scroll_sequence_editor_data.scrollSequenceApiUrl}
                </span>
            </div>
        </>
    )
}