// @ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Icon, Card, CardBody } from '@wordpress/components';
import { home, gallery, tool, cog, currencyDollar, pages, wordpress, video, link, resizeCornerNE, warning } from '@wordpress/icons';

import Tabs from '@mui/material/Tabs';
import Tab from '@mui/material/Tab';
import Box from '@mui/material/Box';
import { styled } from '@mui/material/styles';

import { useDashboardContext } from "./context/DashboardContextProvider";
import type { TabsDataType } from "./types";
import TabGettingStarted from './TabGettingStarted'
import TabJobs from './TabJobs'
import TabUsage from './TabUsage'
import TabDevonly from './TabDevonly'
import NoticeTracking from '../shared/NoticeTracking';

declare const scroll_sequence_editor_data: any;

// TABS DATA
export const tabsData : TabsDataType = [
    {
        title: "Getting Started",
        slug: "getting-started",
        icon: <Icon icon={home} />,
        content: <TabGettingStarted/>
    },
    {
        title: "History",
        slug: "jobs",
        icon: <Icon icon={pages} />,
        content: <TabJobs /> // <>Foo Content</> 
    },  
    {
        title: "Usage",
        slug: "usage",
        icon: <Icon icon={currencyDollar} />,
        content: <TabUsage /> // <>Foo Content</> 
    },    
    {
        title: "Upgrade",
        slug: "upgrade",
        icon: <Icon icon={'cart'} style={{ color: "green",}}/>,
        content: <>upgrade</>
    },       
]  

export default function XTabs(){
    const { tabSlug, setTabSlug,   } = useDashboardContext();
    const tabIndex = tabsData.findIndex(tab => tab.slug === tabSlug);
    console.log('Xtabs tabIndex:',tabIndex,'tabSlug', tabSlug, )

    function a11yProps(index: number ) {
        return {
            id: `scrollsequence-dashboard-tab-${index}`,
            'aria-controls': `scrollsequence-dashboard-tabpanel-${index}`,
        };
    }    
    const handleTabChange = (event: React.SyntheticEvent, newIndex: number ) => {
        console.log('event', event, 'newIndex', newIndex);
        if ( tabsData[newIndex].slug === 'upgrade' ){
            window.location.href = `${scroll_sequence_editor_data.adminUrl}admin.php?page=scrollsequence-dashboard-pricing&trial=true`;
            return;
        }
        setTabSlug(tabsData[newIndex].slug);
    };        

    return(
        <>
            <Tabs
                variant="scrollable"
                scrollButtons="auto"
                allowScrollButtonsMobile
                value={tabIndex}
                onChange={handleTabChange}
                aria-label="Tabs"
                sx={{
                    position: 'relative',
                    zIndex: 1,
                    marginLeft: '7px',

                    '& .MuiTabScrollButton-root.Mui-disabled': {
                        opacity: 1, // Ensure the button is visible
                        color: '#949494', // Set the gray color
                    },
                    '& .Mui-selected': {
                        border: '2px solid rgba(0, 0, 0, 0.1)',
                        borderBottomColor: 'white',
                        borderRadius: '0',
                        backgroundColor: 'rgb(255, 255, 255)',
                    },
                    '& .MuiTabs-indicator': {
                        display: 'none', // somewhere from wp admin randomly picked
                    },
                }}
            >
                {tabsData.map( (tabData:any) => (
                    <TabStyled key={tabData.slug} icon={tabData.icon} label={tabData.title} {...a11yProps(tabData.slug)} iconPosition="start" />
                ))}
                {/* Upgrade link pointing to `${scroll_sequence_editor_data.adminUrl}admin.php?page=scrollsequence-dashboard-pricing&trial=true` */}
            </Tabs>         
            {tabsData.map( (tabData:any, i:number) => (
                <TabPanel key={i} value={tabIndex} index={i}>
                    <NoticeTracking />
                    {tabData.content}
                </TabPanel>
            ))}  
        </> 
    )
}




const TabStyled = styled((props: { label?: string; icon: any, iconPosition: any}) => (
    <Tab disableRipple {...props} />
))(({ theme }) => ({
    textTransform: 'none',
    fontFamily: '-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif',
    color: '#1d2327', // somewhere from wp admin randomly picked
    '&.Mui-selected': {
      color: '#1d2327', // somewhere from wp admin randomly picked
    },
    '&.Mui-focusVisible': {
      backgroundColor: '#3858e980', // somewhere from wp admin randomly picked
    },
}));

function TabPanel(props:{
    children?: React.ReactNode;
    index: number;
    value: number;
}){
    const { children, value, index, ...other } = props;
    return (
        <div
            role="tabpanel"
            hidden={value !== index}
            id={`mui-vertical-tabpanel-${index}`}
            aria-labelledby={`mui-vertical-tab-${index}`}
            {...other}
        >
            {value === index && (
                <Card style={{borderRadius:"0px"}}>
                    <CardBody>
                        {children}
                    </CardBody>
                </Card>  
            )}
        </div>
    );
}