//@ts-ignore: Cannot find module '@wordpress/dom-ready' or its corresponding type declarations.
import domReady from '@wordpress/dom-ready';
//@ts-ignore: Module '"react"' has no exported member 'createRoot'.
import { createRoot } from '@wordpress/element';

import DashboardContextProvider from './context/DashboardContextProvider';
import XTabs from './XTabs';

export default function Dashboard() {

    return (
        <DashboardContextProvider
            // value={{}}
        >
            <XTabs 
            
            />             
        </DashboardContextProvider>
    )
}


domReady( () => {
    // 
    const rootElement =  document.getElementById( 'scrollsequence-dashboard' )
    if ( !rootElement ) {
        console.error( 'Root element for Scroll Sequence Dashboard not found.' );
        return;
    }
    const root = createRoot(rootElement);
    root.render( <Dashboard /> );
} );







/*

import { 
    TabPanel,
    Card,
    //CardHeader,
    CardBody,
    //CardFooter,
    __experimentalText as Text,
    //__experimentalHeading as Heading,
    //@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
} from '@wordpress/components';
import {Icon, home, gallery, tool, cog, page, wordpress  } from '@wordpress/icons'

// import TabDashboard from './TabDashboard'
// import TabMedia from './TabMedia'
// import TabMediaTools from './TabMediaTools'
// import TabSettings from './TabSettings'
// import TabPlay from './TabPlay'
// import TabApi from './TabApi'
// import TabObject from './TabObject'
// import TabDocs from './TabDocs'




function Dashboard(){
    const onSelect = ( tabName:string ) => {
        //console.log( 'Selecting tab', tabName );
    };
    return(
        <TabPanel
            className="scrollsequence-dashboard-panel"
            initialTabName="dashboard"
            //activeClass="scroll-sequence-active-tab"
            onSelect={ onSelect }
            tabs={ [
                {
                    name: 'dashboard',
                    //@ts-ignore: Type '{ icon: Element; style: { marginRight: string; }; }' is missing the following properties from type 
                    title: <><Icon icon={home} style={{marginRight:"10px"}} />Dashboard</>,
                    className: 'scroll-sequence-tab-dashboard',
                    content: <TabDashboard/>
                },
                {
                    name: 'media',
                    //@ts-ignore: Type '{ icon: Element; style: { marginRight: string; }; }' is missing the following properties from type 
                    title: <><Icon icon={gallery} style={{marginRight:"10px"}} />Media</>,
                    className: 'scroll-sequence-tab-media',
                    content: <TabMedia/>
                },        
                {
                    name: 'tools',
                    //@ts-ignore: Type '{ icon: Element; style: { marginRight: string; }; }' is missing the following properties from type 
                    title: <><Icon icon={tool} style={{marginRight:"10px"}} />Media Tools</>,
                    className: 'scroll-sequence-tab-media-tools',
                    content: <TabMediaTools/>
                },                          
                {
                    name: 'settings',
                    //@ts-ignore: Type '{ icon: Element; style: { marginRight: string; }; }' is missing the following properties from type 
                    title: <><Icon icon={cog} style={{marginRight:"10px"}} />Settings</>,
                    className: 'scroll-sequence-tab-settings',
                    content: <TabSettings/>
                },
                {
                    name: 'play',
                    //@ts-ignore: Type '{ icon: Element; style: { marginRight: string; }; }' is missing the following properties from type 
                    title: <><Icon icon={wordpress} style={{marginRight:"10px"}} />Play</>,
                    className: 'scroll-sequence-tab-play',
                    content: <TabPlay/>
                },      
                {
                    name: 'api',
                    //@ts-ignore: Type '{ icon: Element; style: { marginRight: string; }; }' is missing the following properties from type 
                    title: <><Icon icon={wordpress} style={{marginRight:"10px"}} />API</>,
                    className: 'scroll-sequence-tab-api',
                    content: <TabApi/>
                },      
                {
                    name: 'object',
                    //@ts-ignore: Type '{ icon: Element; style: { marginRight: string; }; }' is missing the following properties from type 
                    title: <><Icon icon={wordpress} style={{marginRight:"10px"}} />Object</>,
                    className: 'scroll-sequence-tab-object',
                    content: <TabObject/>
                },                                      
                {
                    name: 'docs',
                    //@ts-ignore: Type '{ icon: Element; style: { marginRight: string; }; }' is missing the following properties from type 
                    title: <><Icon icon={page} style={{marginRight:"10px"}} />Documentation</>,
                    className: 'scroll-sequence-tab-docs',
                    content: <TabDocs/>
                },                
            ] }
        >
            { ( tab:any ) => (
                <Card style={{marginTop:"24px"}}>
                    <CardBody>
                        <Text>{ tab.content }</Text>
                    </CardBody>
                </Card>      
            ) }
        </TabPanel>
    )
}
*/