import { tabsData } from "./XTabs";

// TABS 
export type TabsDataType = {
    title: string,
    slug: string,
    icon?: JSX.Element,
    content: JSX.Element,
}[];
export type TabSlug = typeof tabsData[number]['slug'];

// MEDIA TOOLS
export type MediaToolsDataType = {
    disabled?: boolean, 
    title: string,
    slug: string,
    description: string,
    icon?: JSX.Element,
    guidePages?: GuidePagesType,
    content: JSX.Element,
}[];

export type GuidePagesType = Array<{ 
    content: JSX.Element; 
    image?: JSX.Element; 
}>;

