//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Notice, ExternalLink } from "@wordpress/components";

import getHrefUpgrade from "../v2/getHrefUpgrade";
import type { FsPublicData } from "../v2/blocks/canvas2d/edit/media3tools/types";
import fsPublicDataManager from "./fsPublicDataManager";
/*

This is not used yet, first i need to implements the api checks. 

*/


const lowCreditThreshold = 90; // when remaining credits are less than this, show low credit notice

export default function NoticeCredits(){
    const fsPublicData: null | FsPublicData = fsPublicDataManager.get();
    console.log(' fsPublicData in NoticeCredits ', fsPublicData);

    if ( fsPublicData === null ) {
        return <></>; // still loading
    }

    const remaining = fsPublicData.usage30d?.usage_remaining 
    const isLow = remaining <= lowCreditThreshold;

    if ( remaining === undefined ) {
        return <></>; // still loading or no data
    }

    if ( remaining > lowCreditThreshold ) {
        return <></>; // enough credits, no notice needed
    }

    // show a info notice about low credits
    if (isLow) {
        return (
        <Notice status="warning" isDismissible={false} style={{marginBottom: '10px'}}>
            <strong>Low Credits Warning:</strong> You are running low on credits. You have <strong>{remaining}</strong> credits remaining. Please <ExternalLink href={getHrefUpgrade()} >upgrade your plan</ExternalLink> to avoid interruptions in service.
        </Notice>
        )
    }
    // show a warning notice about no credits
    return (
    <Notice status="error" isDismissible={false} style={{marginBottom: '10px'}}>
        <strong>No Credits Available:</strong> You have no API credits left. Please <ExternalLink href={getHrefUpgrade()} >upgrade your plan</ExternalLink> to gain more credits and continue using premium features.
    </Notice>
    )
}


