import type { FsPublicData } from "../v2/blocks/canvas2d/edit/media3tools/types";
// usage in API (here we receive and store the data):
// fsPublicDataManager.update(data.fsPublicData);
// usage in other components:
// const fsPublicData = fsPublicDataManager.get();

/*

Used in a number of places

update: 
- dashboard usage tab
- file upload
- actionGenerate (run media3tools job)

get:
- noticeCredits (show low credits warning


*/


// Create a singleton class that accepts fsPublicData in update() and returns it in get(), it will be used across various components, but should share just one state across all of them.
class FsPublicDataManager {
    private static instance: FsPublicDataManager;
    private fsPublicData: null | FsPublicData = null;  
    private constructor() {}

    public static getInstance(): FsPublicDataManager {
        if (!FsPublicDataManager.instance) {
            FsPublicDataManager.instance = new FsPublicDataManager();
        }
        return FsPublicDataManager.instance;
    }
    public update(fsPublicData: FsPublicData) {
        this.fsPublicData = fsPublicData;
    }
    public get(): null | FsPublicData {
        return this.fsPublicData;
    }
}
const fsPublicDataManager = FsPublicDataManager.getInstance();
export default fsPublicDataManager;

