import { imageGroupWpMediaDefaults, imageGroupUrlListDefaults, videoGroupWpMediaDefaults, videoGroupUrlListDefaults, imageGroupGapDefaults } from './defaults';
import { AttributesCanvas2d } from '../../v2/blocks/canvas2d/types'
export function addMediaGroup({
    type, 
    attributes, 
    setAttributes,
}:{
    type: 'wpMedia' | 'urlList' | 'wpVideo' | 'urlVideo' | 'gap'
    attributes:AttributesCanvas2d,
    setAttributes:any
}){
    let newMediaGroup = null;
    switch(type) {
        case 'wpMedia':
            newMediaGroup = imageGroupWpMediaDefaults
            break;
        case 'urlList':
            newMediaGroup = imageGroupUrlListDefaults
            break;
        case 'wpVideo':
            newMediaGroup = videoGroupWpMediaDefaults
            break;
        case 'urlVideo':
            newMediaGroup = videoGroupUrlListDefaults
            break;            
        case 'gap':
            newMediaGroup = imageGroupGapDefaults
            break;            
        default:
            console.error('Unknown media group type', type)
    }

    const prevMediaGroups = attributes.mediaGroups;
    const newMediaGroups = [...prevMediaGroups, newMediaGroup]; // copy the array


    setAttributes({mediaGroups: newMediaGroups})
    //console.log('addMediaGroup()', type, mediaGroups, newMediaGroup)
}

/*
export function addMediaGroupWpImages(mediaGroups:any, setMediaGroups:any){
    setMediaGroups([
        ...mediaGroups, 
        imageGroupWpMediaDefaults,
    ])
}

export function addMediaGroupUrlList(mediaGroups:any, setMediaGroups:any){
    setMediaGroups([
        ...mediaGroups, 
        imageGroupUrlListDefaults,
    ])
}
export function addVideoGroupWpVideo(mediaGroups:any, setMediaGroups:any){
    setMediaGroups([
        ...mediaGroups, 
        videoGroupWpMediaDefaults,
    ])
}

export function addVideoGroupUrlVideo(mediaGroups:any, setMediaGroups:any){
    setMediaGroups([
        ...mediaGroups, 
        videoGroupUrlListDefaults,
    ])
}
export function addMediaGroupGap(mediaGroups:any, setMediaGroups:any){
    setMediaGroups([
        ...mediaGroups, 
        imageGroupGapDefaults,
    ])
}
*/