import { useEffect, useState } from 'react';
//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
import { 
    Button, Dropdown, Spinner, TextControl, Flex, FlexItem, Modal, PanelRow, TextareaControl,
    __experimentalHStack as HStack,
//@ts-ignore
} from '@wordpress/components';

import WpMediaUploader from './WpMediaUploader'

import ModalImagesUrl from './ModalImagesUrl';
import ModalTemplates from './ModalTemplates';
import { addMediaGroup } from '../addMediaGroup'
import { imageGroupWpMediaDefaults, videoGroupWpMediaDefaults } from '../defaults'
import { AttributesCanvas2d } from '../../../v2/blocks/canvas2d/types';
import { IconSparkle } from '../../../icons'
 // TODO: make this nice and working for all types

type RenderComplexUi = 
    true | // this is in the sidebar editor placeholder 
    false; // this is in the wp-admin dashboard media cpt editor

export default function PlaceholderEmptyMedia({
    renderComplexUi = true,
    attributes,
    setAttributes,
    setIndexActiveGroup,
    setShow,
}:{ 
    renderComplexUi: RenderComplexUi,
    attributes: AttributesCanvas2d,
    setAttributes: any,
    setIndexActiveGroup: any
    setShow: React.Dispatch<React.SetStateAction<'canvas' | 'adder' | 'media-tools'>>
}){

    const [ isModalTemplateOpen, setIsModalTemplateOpen ] =  useState(false);
    const [ isModalImagesUrlOpen, setIsModalImagesUrlOpen ] =  useState(false);

    return (
        <>
            <div style={{paddingLeft:"0.5rem"}}>
                <p>{__("Generate New Media", "scrollsequence")}</p>
                <HStack alignment="left" spacing="4" style={{paddingLeft:"0.5rem"}} >
                    <Button
                        variant="primary"
                        icon={ <IconSparkle width={16} height={16} /> }
                        onClick={ () => setShow('media-tools') }
                        //aria-expanded={ isOpen }
                    >
                       Media Tools
                    </Button>                  
                </HStack>
                <p>{__("Use Existing Media", "scrollsequence")}</p>
                <Flex
                    direction={[
                        'column',
                        'row'
                    ]}
                    justify="start"
                    wrap={true}
                    style={{ paddingLeft: "0.5rem" }}
                >
                    {/* --------------------------      IMAGES - WP          -------------------------- */}
                    <FlexItem>
                        <WpMediaUploader
                            fileType='image'
                            multiple={true}
                            onCompleteSelection={(selectedIds: number[]) => {
                                // Update media groups logic
                                const imageGroupIndex = ( attributes.mediaGroups?.length ? (attributes.mediaGroups.length ) : 0 );
                                const imageGroup = imageGroupWpMediaDefaults; // empty
                                const newMediaGroups = [...attributes.mediaGroups];
                                newMediaGroups[imageGroupIndex] = { ...imageGroup, images: selectedIds };
                                setAttributes({ mediaGroups: newMediaGroups });          
                                // Close the adder and switch to the new group                      
                                setShow('canvas');
                                setIndexActiveGroup(attributes.mediaGroups.length)
                            }}
                        >
                            {(runUploader) => (
                                <Button variant="secondary" onClick={runUploader}>{__('Images WP', 'scrollsequence')}</Button> 
                            )}
                        </WpMediaUploader>
                    </FlexItem>
                    {/* --------------------------      IMAGES - URL LIST    -------------------------- */}
                    <FlexItem>
                        <Button
                            variant="secondary"
                            onClick={ () => setIsModalImagesUrlOpen(true) }
                        >
                            Images URL
                        </Button>
                    </FlexItem>

                    {/* --------------------------      VIDEO - WP          -------------------------- */}
                    <FlexItem>
                        <WpMediaUploader
                            fileType='video'
                            multiple={false}
                            onCompleteSelection={(selectedIds: number[]) => {
                                //handleSelectionComplete(selectedIds)
                                alert('Video upload not implemented yet')
                            }}  
                        >
                            {(runUploader) => (
                                <Button disabled variant="secondary"  onClick={runUploader}>{__('Video WP', 'scrollsequence')}</Button> 
                            )}
                        </WpMediaUploader>
                    </FlexItem>
                    {/* --------------------------      VIDEO - URL    -------------------------- */}
                    <FlexItem>
                        <Button 
                            disabled
                            variant='secondary'	
                            style={{margin:"0.3rem"}}
                            onClick={ ()=>{
                                addMediaGroup({type: 'urlVideo', attributes, setAttributes })
                            }}
                        >
                            Video URL
                        </Button>                    
                    </FlexItem>
                </Flex>
                <p>{__("Templates", "scrollsequence")}</p>
                <HStack alignment="left" spacing="4" style={{paddingLeft:"0.5rem"}} >
                    <Button 
                        
                        variant="secondary"	
                        style={{margin:"0.3rem"}}
                        onClick={ ()=>{
                            //addMediaGroup({type: 'gap', mediaGroups, setMediaGroups }) 
                            setIsModalTemplateOpen(true);
                        }}
                    >
                        Select Template
                    </Button>                        
                </HStack>               
                <p>{__("Gap", "scrollsequence")}</p>
                <HStack alignment="left" spacing="4" style={{paddingLeft:"0.5rem"}} >
                    <Button 
                        variant="secondary"	
                        disabled
                        style={{margin:"0.3rem"}}
                        onClick={ ()=>{
                            addMediaGroup({type: 'gap', attributes, setAttributes }) 
                        }}
                    >
                        Gap
                    </Button>                        
                </HStack>     
            </div>
            { isModalTemplateOpen &&
                <ModalTemplates setIsOpen={setIsModalTemplateOpen} attributes={attributes} setAttributes={setAttributes} setShow={setShow} />
            }
            { isModalImagesUrlOpen &&
                <ModalImagesUrl setIsOpen={setIsModalImagesUrlOpen} attributes={attributes} setAttributes={setAttributes} setShow={setShow}/>
            }
        </>
    )
}
