import Box from '@mui/material/Box';

export default function TabPanel(props:{
    children?: React.ReactNode;
    index: number;
    value: number;
}){
    const { children, value, index, ...other } = props;
    return (
        <div
            role="tabpanel"
            hidden={value !== index}
            id={`vertical-tabpanel-${index}`}
            aria-labelledby={`vertical-tab-${index}`}
            {...other}
        >
            {value === index && (
            <Box>
                {children}
            </Box>
            )}
        </div>
    );
}
    