import { z } from "zod"

export const mediaGroupPositionAndSizeSchema = z.object({
  bgSize: z
    .union([z.literal("contain"), z.literal("cover"), z.literal("custom")])
    .optional(),
  bgPosition: z
    .object({
      x: z.number(),
      y: z.number()
    })
    .optional()
})

export const imagesWpArraySchema = z.array(
  z.union([
    z.number(),
    z.object({
      i: z.number(),
      dur: z.number().optional()
    })
  ])
)

export const imagesUrlListArraySchema = z.array(
  z.union([
    z.string(),
    z.object({
      i: z.string(),
      dur: z.number().optional()
    })
  ])
)

export const imageGroupWpSchema = mediaGroupPositionAndSizeSchema.and(
  z.object({
    type: z.literal("wpMedia"),
    images: imagesWpArraySchema,
    duration: z.number().optional()
  })
)

export const imageGroupUrlListSchema = mediaGroupPositionAndSizeSchema.and(
  z.object({
    type: z.literal("urlList"),
    prefix: z.string().optional(),
    suffix: z.string().optional(),
    images: imagesUrlListArraySchema,
    duration: z.number().optional()
  })
)

export const imageGroupGapSchema = z.object({
  type: z.literal("gap"),
  duration: z.number()
})

export const imageGroupSchema = z.union([
  imageGroupGapSchema,
  imageGroupWpSchema,
  imageGroupUrlListSchema
])

export const imageGroupsSchema = z.array(imageGroupSchema)

export const videoGroupWpSchema = mediaGroupPositionAndSizeSchema.and(
  z.object({
    type: z.literal("wpVideo"),
    video: z.number().optional(),
    duration: z.number().optional()
  })
)

export const videoGroupUrlSchema = mediaGroupPositionAndSizeSchema.and(
  z.object({
    type: z.literal("urlVideo"),
    video: z.string().optional(),
    duration: z.number().optional()
  })
)

export const videoGroupSchema = z.union([
  videoGroupWpSchema,
  videoGroupUrlSchema
])

export const mediaGroupSchema = z.union([imageGroupSchema, videoGroupSchema])

export const mediaGroupsSchema = z.array(mediaGroupSchema)
