//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/element' or its corresponding type declarations.
import { useState } from '@wordpress/element';
import {
	BlockControls,
	__experimentalBlockFullHeightAligmentControl as FullHeightAlignmentControl,
	//@ts-ignore
} from '@wordpress/block-editor';

import { AttributesCanvas3d } from '../../types';
//import cleanEmptyObject from '../../../utils/cleanEmptyObject'

export default function BlockControlsC2d({
    attributes, 
    setAttributes,
}:{
    attributes: AttributesCanvas3d
    setAttributes: any
}){
	const { height, heightUnit } = attributes;

    const [ prevHeightValue, setPrevHeightValue ] = useState( height );
    const [ prevHeightUnit, setPrevHeightUnit ] =
        useState( heightUnit );
    const isFullHeight = heightUnit === 'vh' && height === 100;
    
    const toggleFullHeight = () => {
        if ( isFullHeight ) {
            // If there aren't previous values, take the default ones.
            if ( prevHeightUnit === 'vh' && prevHeightValue === 100 ) {
                return setAttributes( {
                    height: undefined,
                    heightUnit: undefined,
                } );
            }

            // Set the previous values of height.
            return setAttributes( {
                height: prevHeightValue,
                heightUnit: prevHeightUnit,
            } );
        }

        setPrevHeightValue( height );
        setPrevHeightUnit( heightUnit );

        // Set full height, and clear any aspect ratio value.
        return setAttributes( {
            height: 100,
            heightUnit: 'vh',
            style: { // trying to get rid of cleanEmptyObject() wp function
                ...attributes?.style,
                dimensions: {
                    ...attributes?.style?.dimensions,
                    aspectRatio: undefined, // Reset aspect ratio when height is set.
                },
            },      
        } );
    };

    return (
        <>
            <BlockControls group="block">
                <FullHeightAlignmentControl
                    isActive={ isFullHeight }
                    onToggle={ toggleFullHeight }
                   // isDisabled={ ! hasInnerBlocks }
                />
            </BlockControls>
            <BlockControls group="other">
                Media 3d
            </BlockControls>
        </>
    )
}