

//@ts-ignore:
import { ToolbarButton } from '@wordpress/components';
//@ts-ignore:
import { BlockControls } from '@wordpress/block-editor';
import { plus, } from '@wordpress/icons';
import React from 'react';

// this component is used to toggle a boolean and show the status of the boolean as active/inactive button state
// it receives showMediaGroupAdder and setShowMediaGroupAdder as props from the parent component BlockControlsCanvas2d

export default function ButtonMediaGroupAdder({ show, setShow }: {show: 'canvas' | 'adder' | 'media-tools', setShow: React.Dispatch<React.SetStateAction<'canvas' | 'adder' | 'media-tools'>>}) {
    return (
        <ToolbarButton
            icon={plus}
            label="Add Media Group"
            onClick={() => {
                setShow(show === 'adder' ? 'canvas' : 'adder')
            }}
            isActive={show === 'adder'}
        />
    );
}