//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
import { useState } from '@wordpress/element';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import {  Modal, Button, } from '@wordpress/components';
import { fullscreen } from '@wordpress/icons';
import Stack from '@mui/material/Stack';
import Tabs from '@mui/material/Tabs';

import CreateMediaGroupDropdown from '../../../../../../shared/media-2d/components/CreateMediaGroupDropdown';
import { AttributesCanvas2d } from '../../../types';
import type { MediaGroups } from '../../../../../../shared/media-2d/types';
//import PlaceholderEmptyMedia from '../../../../../../shared/media-2d/components/PlaceholderEmptyMedia';
import IconImageGroups from '../../../../../../shared/media-2d/components/IconImageGroups';
import TabStyled from '../../../../../../shared/media-2d/components/TabStyled';
import TabPanel from '../../../../../../shared/media-2d/components/TabPanel';

import SingleGroupControls from './single-group-controls';
import MediaManagerFullWidth from '../../../../../../shared/media-2d/media-manager-full-w';


export default function MediaGroupsManager({
    attributes, 
    setAttributes, 
    //hasMediaGroups,
    indexActiveGroup,
    setIndexActiveGroup,
}:{
    attributes: AttributesCanvas2d, 
    setAttributes:any, 
    //hasMediaGroups:boolean
    indexActiveGroup: number
    setIndexActiveGroup: any
}){


    //TABS
    function a11yProps(index: number) {
        return {
            id: `vertical-tab-${index}`,
            'aria-controls': `vertical-tabpanel-${index}`,
        };
    }
    const handleTabChange = (event: React.SyntheticEvent, newValue: number) => {
        setIndexActiveGroup(newValue);
    };    

    const [ isModalOpen, setIsModalOpen ] = useState(false);

    // if(!hasMediaGroups) return (
    //     <div style={{marginTop: "2rem", marginBottom: "2rem"}}>
    //         No media groups yet, please add one.
    //         {/* <PlaceholderEmptyMedia 
    //             renderComplexUi={false} 
    //             setMediaGroups={setMediaGroups}
    //         /> */}
    //     </div>
    // )

    return (
        <>
            <div style={{display: "flex", justifyContent:"space-between", alignItems:"center", marginBottom: "1rem", marginTop: "1rem"}}>
                <p style={{
                        fontSize: "14px", fontWeight: "500", lineHeight: "1.4", 
                        marginTop: "2rem", marginBottom: "2rem", marginLeft: "6px",
                    }}
                >
                    {__("Media Groups", "scrollsequence")}
                </p>
                <div style={{display: "flex", alignItems:"center", gap: "0.25rem"}}>
                    <Button 
                        icon={fullscreen}
                        label={__("Manage Media Groups", "scrollsequence")}
                        onClick={ ()=>{ setIsModalOpen(true) } }
                    />
                    <CreateMediaGroupDropdown 
                        attributes={attributes}
                        setAttributes={setAttributes}
                        index={indexActiveGroup}
                        setIndex={setIndexActiveGroup}
                    />
                </div>
            </div>
            <Stack direction="row" justifyContent={"start"} sx={{borderBottom: "1px solid #ccc", }}>
                <Tabs
                    variant="scrollable"
                    scrollButtons="auto"
                    value={indexActiveGroup}
                    onChange={handleTabChange}
                    aria-label="Tabs"
                    sx={{
                        '& .MuiTabScrollButton-root.Mui-disabled': {
                            opacity: 1, // Ensure the button is visible
                            color: '#949494', // Set the gray color
                        },
                    }}
                >
                    {attributes.mediaGroups.map( (mediaGroup:any, i:number) => (
                        <TabStyled key={i} icon={<IconImageGroups imageGroup={mediaGroup}/>} {...a11yProps(i)} />
                    ))}
                </Tabs>  
            </Stack>     

            <div style={{marginLeft: "10px", marginRight: "10px", }}>
                {attributes.mediaGroups.map( (tab:any, i:number) => (
                    <TabPanel key={i} value={indexActiveGroup} index={i}>
                        <SingleGroupControls
                            attributes={attributes} 
                            setAttributes={setAttributes} 
                            index={indexActiveGroup}
                            setIndex={setIndexActiveGroup}
                            //isModalOpen={isModalOpen} // removed recently, but was there and it was fine
                            //setIsModalOpen={setIsModalOpen}  // removed recently, but was there and it was fine
                        />
                    </TabPanel>
                ))}           
            </div>         

            { isModalOpen && (
                <Modal 
                    title={__("This is my modal", "scrollsequence")}
                    onRequestClose={ ()=>{ setIsModalOpen(false) } }
                    size="fill"
                    //headerActions={<>HeaderAction</>}
                    shouldCloseOnClickOutside={false}
                >
                    <MediaManagerFullWidth
                        attributes={attributes}
                        setAttributes={setAttributes}
                        index={indexActiveGroup}
                        setIndex={setIndexActiveGroup}
                    />
                </Modal>
            ) }	                 
        </>
    )
}