//@ts-ignore
import { __ } from '@wordpress/i18n';
// @ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { DropdownMenu, MenuGroup, MenuItem } from '@wordpress/components';
import { arrowUp, alignJustify, replace } from '@wordpress/icons';

import type { AttributesCanvas2d } from '../../../../types';

export default function BulkActionsUrl({
    attributes, 
    setAttributes, 
    index,
}:{
    attributes: AttributesCanvas2d, 
    setAttributes: (attributes: any) => void, 
    index: number,
}) {
    function handleSortByName() {
        // Sort images (array of strings) alphabetically
        const newMediaGroups = [...attributes.mediaGroups];
        const newMediaGroup = { ...newMediaGroups[index] } as any;
        newMediaGroup.images = [...newMediaGroup.images].sort((a: string, b: string) => a.localeCompare(b));
        newMediaGroups[index] = newMediaGroup;
        setAttributes({ mediaGroups: newMediaGroups });
    }

    function handleReverseOrder() {
        const newMediaGroups = [...attributes.mediaGroups];
        const newMediaGroup = { ...newMediaGroups[index] } as any;
        newMediaGroup.images = [...newMediaGroup.images].reverse();
        newMediaGroups[index] = newMediaGroup;
        setAttributes({ mediaGroups: newMediaGroups });
    }

    return (
        <DropdownMenu icon={alignJustify} label={__('Bulk Actions','scrollsequence')}>
            {({ onClose }: any) => (
                <MenuGroup>
                    <MenuItem icon={arrowUp} onClick={() => { handleSortByName(); onClose(); }}>
                        Sort by Name
                    </MenuItem>
                    <MenuItem icon={replace} onClick={() => { handleReverseOrder(); onClose(); }}>
                        Reverse Order
                    </MenuItem>
                </MenuGroup>
            )}
        </DropdownMenu>
    );
}