//@ts-ignore
import { __ } from '@wordpress/i18n';
import { useState } from 'react';
// @ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { DropdownMenu, MenuGroup, MenuItem } from '@wordpress/components';
import { arrowUp, arrowDown, alignJustify, replace } from '@wordpress/icons';

import type { AttributesCanvas2d } from '../../../../types';
import type { MediaGroup } from '../../../../../../../shared/media-2d/types';


export default function BulkActions({
    attributes, 
    setAttributes, 
    index,
    thumbnails,  
    setThumbnails, 
}:{
    attributes: AttributesCanvas2d, 
    setAttributes: (attributes: any) => void, 
    index: number,
    thumbnails: any[]
    setThumbnails: (thumbnails: any[]) => void,
    
}) {
    
    function handleSortByName() {
        // Sort thumbnails by file_name
        const sortedThumbs = [...thumbnails].sort((a, b) => a.file_name.localeCompare(b.file_name));
        setThumbnails(sortedThumbs);

        // Update images array in media group to match sorted order
        const newMediaGroups = [...attributes.mediaGroups];
        const newMediaGroup = {...newMediaGroups[index]} as any
        newMediaGroup.images = sortedThumbs.map(t => t.id);
        newMediaGroups[index] = newMediaGroup;
        setAttributes({ mediaGroups: newMediaGroups });
    }
    function handleSortById() {
        const sortedThumbs = [...thumbnails].sort((a, b) => a.id - b.id);
        setThumbnails(sortedThumbs);

        const newMediaGroups = [...attributes.mediaGroups];
        const newMediaGroup = {...newMediaGroups[index]} as any;
        newMediaGroup.images = sortedThumbs.map(t => t.id);
        newMediaGroups[index] = newMediaGroup;
        setAttributes({ mediaGroups: newMediaGroups });
    }
    function handleReverseOrder() {
        const reversedThumbs = [...thumbnails].reverse();
        setThumbnails(reversedThumbs);

        const newMediaGroups = [...attributes.mediaGroups];
        const newMediaGroup = {...newMediaGroups[index]} as any;
        newMediaGroup.images = reversedThumbs.map(t => t.id);
        newMediaGroups[index] = newMediaGroup;
        setAttributes({ mediaGroups: newMediaGroups });
    }

    return (
        <>
            <DropdownMenu icon={ alignJustify } label={__('Bulk Actions','scrollsequence') }>
                { ( { onClose }:any ) => (
                    <>
                        <MenuGroup>
                            <MenuItem icon={ arrowUp } onClick={ () => { handleSortByName(); onClose();}}>
                                Sort by Name
                            </MenuItem>
                            <MenuItem icon={ arrowDown } onClick={ () => { handleSortById(); onClose();}}>
                                Sort by Id
                            </MenuItem>
                            <MenuItem icon={ replace } onClick={ () => { handleReverseOrder(); onClose();}}>
                                Reverse Order
                            </MenuItem>                            
                        </MenuGroup>
                        {/* <MenuGroup>
                            <MenuItem icon={ trash } onClick={ () => { console.log( 'r' ); onClose();}}>
                                Remove
                            </MenuItem>
                        </MenuGroup> */}
                    </>
                ) }
            </DropdownMenu>  
        </>
    );
}