import React, { useEffect, useState } from 'react';
//@ts-ignore
import { closeSmall } from '@wordpress/icons';
// @ts-ignore
import { Icon, Notice } from '@wordpress/components';
import { DC2D } from '../../../../../../../dbg'
import getHrefUpgrade from '../../../../../../getHrefUpgrade';

// Todo: Implement drag and drop. see dndkit.com (already installed)
declare const wp: any; 
const { applyFilters, } = wp.hooks; 

type Thumbnail = {
  id: number;
  url: string | null;
  file_name: string; 
}

export default function ThumbnailListIds({ 
  thumbnails, 
  onRemove
}:{
  thumbnails:Thumbnail[], 
  onRemove: (idx: number) => void
}){


  if (!thumbnails.length) return <p>No thumbnails available</p>;


  const hasWss = applyFilters('scrollsequence-c2d-wss-control', true) as boolean;
  const overWss = hasWss ? thumbnails.filter((_, idx) => idx > 99).length : 0;

  return (
    <div>
      {overWss > 0 && (
        <Notice status="warning" isDismissible={false} style={{marginBottom: '10px'}}>
          <strong>Image limit exceeded:</strong> You have {overWss} image{overWss > 1 ? 's' : ''} over the 100 image limit. 
          Images beyond position 100 will not be displayed on the front end.
          <br/>
          Please <a href={getHrefUpgrade()} target="_blank">upgrade</a> to a premium plan to remove this limit.
        </Notice>
      )}    
      <div style={{display: 'flex',flexWrap: 'wrap',gap: '10px',overflow: 'auto',maxHeight: '200px'}}>
        {thumbnails.map(({ id, url }, idx) => (
          <div key={id + '-' + idx} style={{position: 'relative', border: '1px solid #ddd', padding: '5px', borderRadius: '4px'}}>

            {url ? (
              <img src={url} style={{display: 'block',width: '75px', height: 'auto', borderRadius: '4px',}}/>
            ) : (
              <span style={{color: '#721c24', fontSize: 12, textAlign: 'center', padding: 4}}>
                Missing image<br/>ID: {id}
              </span>
            )}

            { idx > 99 && hasWss && (
                <div
                  style={{
                    position: 'absolute',
                    top: '5px',
                    left: '5px',
                    right: '5px',
                    bottom: '5px',
                    background: 'rgba(255, 255, 255, 0.7)',
                    display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'center',
                    borderRadius: '4px',
                    pointerEvents: 'none',
                  }}
                >
                  <span 
                    style={{
                      background: 'rgba(220, 38, 38, 0.9)',
                      color: 'white',
                      padding: '2px 6px',
                      borderRadius: '3px',
                      fontSize: 10,
                      fontWeight: 600,
                      textTransform: 'uppercase',
                    }}
                  >
                    Over Limit
                  </span>
                </div>
            )}
            <button
              type="button"
              onClick={() => onRemove(idx)}
              style={{
                position: 'absolute',
                top: 2,
                right: 2,
                background: 'rgba(255,255,255,0.8)',
                border: 'none',
                borderRadius: '50%',
                width: 20,
                height: 20,
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'center',
                cursor: 'pointer',
                padding: 0,
              }}
              aria-label="Remove"
            >
              <span style={{fontSize: 14}}><Icon icon={closeSmall} /></span>
            </button>
          </div>
        ))}
      </div>
    </div>
  );
}

