//@ts-ignore
import { Notice } from '@wordpress/components';
import getImageUrlFromPreSufix from '../../../../../../../shared/media-2d/utils';
import getHrefUpgrade from '../../../../../../getHrefUpgrade';

declare const wp: any; 
const { applyFilters, } = wp.hooks; 

export default function ThumbnailListUrls({prefix, suffix, images, }:{prefix?:string, suffix?:string, images: string[]}) {

  if (!images.length) return <p>No thumbnails available</p>;

  const hasWss = applyFilters('scrollsequence-c2d-wss-control', true) as boolean;
  const overWss = hasWss ? images.filter((_, idx) => idx > 99).length : 0;

  return (
    <div>
      {overWss > 0 && (
        <Notice status="warning" isDismissible={false} style={{marginBottom: '10px'}}>
          <strong>Image limit exceeded:</strong> You have {overWss} image{overWss > 1 ? 's' : ''} over the 100 image limit. 
          Images beyond position 100 will not be displayed on the front end.
          <br/>
          Please <a href={getHrefUpgrade()} target="_blank">upgrade</a> to a premium plan to remove this limit.
        </Notice>
      )}         
      <div style={{display: 'flex',flexWrap: 'wrap',gap: '10px',overflow: 'auto',maxHeight: '200px'}}>
        {images.map((image,index) => (
          <div key={index} style={{position: "relative", border: '1px solid #ddd', padding: '5px', borderRadius: '4px'}}>
            <img 
              src={ getImageUrlFromPreSufix(image, prefix, suffix) } 
              onError={(e)=>{
                console.error('ThumbnailList() Error loading image Url:', getImageUrlFromPreSufix(image, prefix, suffix) )
                //console.error('Error:', e)
                // const element = e.target as HTMLImageElement;
                // element.src = 'https://via.placeholder.com/75'; // Placeholder image
                // element.alt = 'Image not found'; // Optional: Set alt text
              }}
              style={{display: 'block',width: '75px', height: 'auto', borderRadius: '4px',}}
            />

            { index > 99 && hasWss && (
                <div
                  style={{
                    position: 'absolute',
                    top: '5px',
                    left: '5px',
                    right: '5px',
                    bottom: '5px',
                    background: 'rgba(255, 255, 255, 0.7)',
                    display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'center',
                    borderRadius: '4px',
                    pointerEvents: 'none',
                  }}
                >
                  <span 
                    style={{
                      background: 'rgba(220, 38, 38, 0.9)',
                      color: 'white',
                      padding: '2px 6px',
                      borderRadius: '3px',
                      fontSize: 10,
                      fontWeight: 600,
                      textTransform: 'uppercase',
                    }}
                  >
                    Over Limit
                  </span>
                </div>
            )}


          </div>
        ))}
      </div>    
    </div>
  )
}