//@ts-ignore
import { __ } from '@wordpress/i18n';
//@ts-ignore
import { SelectControl } from '@wordpress/components';

type AspectRatioControlProps<T extends string | undefined> = {
    onChange: (newValue: T) => void;
    value: T;
    options: ReadonlyArray<T>;
};

export default function AspectRatioControl<T extends string | undefined>({
    onChange,
    value,
    options
}: AspectRatioControlProps<T>) {

    const optionsMap = options.map(format => ({
        label: format === undefined ? "Default" : format.toUpperCase(),
        value: format === undefined ? "" : format,
    }));

    return (
        <SelectControl
            label={__("Aspect Ratio", "scrollsequence")}
            value={value}
            options={optionsMap}
            onChange={(val : T) => {
                // If val is "", treat it as undefined
                onChange((val === "" ? undefined : val) as T);
            }}
            __next40pxDefaultSize
            __nextHasNoMarginBottom
        />
    );
}