//@ts-ignore
import { TextareaControl, Button, Flex, FlexItem, ToggleControl} from '@wordpress/components';
import { useImg2ImgContext, useToolsContext } from '../../../ContextProvider';

import OutputFormatControl from '../../../to-be-shared/OutputFormatControl';
import NumberOfOutputsControl from '../../../to-be-shared/NumberOfOutputsControl';
import InputImagesControl from '../../../to-be-shared/InputImageControl';
import AspectRatioControl from '../../../to-be-shared/AspectRatioControl';

import { IMG2IMG_MODEL_NB } from '../../../constants'
import type { Img2ImgModelContextNb, ToolsContextType } from '../../../types';
import GenerateAbortButtons from '../../../GenerateAbortButtons';

export default function ModelDisplayNb() {
    const { progress } = useToolsContext();
    const { models  } = useImg2ImgContext();

    const modelNb = models.find(model => model.id === 'nb')!;
    const modelState = modelNb.modelState;
    const setModelState = modelNb.setModelState;

    // Determine if we can generate
    const canGenerate = Boolean(modelState.input.image_urls.length >=1 && modelState.input.prompt);

    return (
        <>

            <Flex gap={2} align="flex-end" style={{ marginBottom: '1rem' }} justify="start">
                <FlexItem style={{ minWidth: 100 }}>
                    <InputImagesControl
                        label={IMG2IMG_MODEL_NB.config.image_urlLabels[0]}
                        progress={progress}

                        imageS3Url={modelState.input.image_urls[0] || ''}

                        onUploadFinished={(s3Url: string, fileName: string) => {
                            console.log('ModelDisplayNb handleUploadComplete() s3Urls:', s3Url);
                            setModelState( ( prev : Img2ImgModelContextNb ) : Img2ImgModelContextNb => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    image_urls:  [s3Url, ...prev.input.image_urls.slice(1)] // add to array to index 0
                                }
                            }));
                        }}
                        onRemove={() => {
                            console.log('ModelDisplayNb handleRemoveMedia() ');
                            setModelState( ( prev : Img2ImgModelContextNb ) : Img2ImgModelContextNb => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    // remove index 0
                                    image_urls: prev.input.image_urls.slice(1)
                                }
                            }));
                        }}
                    />
                </FlexItem>
                <FlexItem style={{ flex: 1, minWidth: 100 }}>
                    <InputImagesControl
                        label={IMG2IMG_MODEL_NB.config.image_urlLabels[1]}
                        progress={progress}

                        imageS3Url={modelState.input.image_urls[1] || ''}

                        onUploadFinished={(s3Url: string, fileName: string) => {
                            console.log('ModelDisplayNb handleUploadComplete() s3Urls:', s3Url);
                            setModelState( ( prev : Img2ImgModelContextNb ) : Img2ImgModelContextNb => ( {
                                ...prev,
                                input: {
                                    ...prev.input,

                                    // This looks too complex, not sure it works as intended, lets test!
                                    image_urls:   // add to array to index 1, or if empty, add to index 0
                                        prev.input.image_urls.length === 0 ? [s3Url] :
                                        prev.input.image_urls.length === 1 ? [prev.input.image_urls[0], s3Url] :
                                        [prev.input.image_urls[0], s3Url, ...prev.input.image_urls.slice(2)]
                                }
                            }));
                        }}
                        onRemove={() => {
                            console.log('ModelDisplayNb handleRemoveMedia() ');
                            setModelState( ( prev : Img2ImgModelContextNb ) : Img2ImgModelContextNb => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    // This looks too complex, not sure it works as intended, lets test!
                                    // remove index 1
                                    image_urls: prev.input.image_urls.length <= 1 ? prev.input.image_urls.slice(0,1) : [prev.input.image_urls[0], ...prev.input.image_urls.slice(2)]
                                }
                            }));
                        }}
                    />                        
                </FlexItem>                
            </Flex>



            <TextareaControl
                label="Prompt"
                value={modelState.input.prompt}
                onChange={(newPrompt: string) => {
                    setModelState( ( prev : Img2ImgModelContextNb ) : Img2ImgModelContextNb => ( {
                        ...prev,
                        input: {
                            ...prev.input,
                            prompt: newPrompt
                        }
                    }));
                }}
                rows={3}
            />

            <Flex gap={2} align="flex-end" style={{ marginBottom: '1rem' }}>
                <FlexItem style={{ flex: 1, minWidth: 100 }}>
                    <OutputFormatControl
                        value={modelState.input.output_format}
                        onChange={(newFormat) => {
                            setModelState( ( prev : Img2ImgModelContextNb ) : Img2ImgModelContextNb => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    output_format: newFormat
                                }
                            }));
                        }}
                        options={IMG2IMG_MODEL_NB.config.output_formatOptions}
                    />  
                </FlexItem>
                <FlexItem style={{ flex: 1, minWidth: 100 }}>                 
                    <NumberOfOutputsControl
                        value={modelState.input.num_images}
                        options={IMG2IMG_MODEL_NB.config.num_imagesOptions}
                        onChange={(newNumOutputs) => {
                            setModelState( ( prev : Img2ImgModelContextNb ) : Img2ImgModelContextNb => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    num_images: newNumOutputs
                                }
                            }));
                        }}
                    />              
                </FlexItem>
                <FlexItem style={{ flex: 1, minWidth: 100 }}>
                    <AspectRatioControl
                        value={modelState.input.aspect_ratio}
                        onChange={(newAspectRatio) => {
                            setModelState( ( prev : Img2ImgModelContextNb ) : Img2ImgModelContextNb => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    aspect_ratio: newAspectRatio
                                }
                            }));
                        }}
                        options={IMG2IMG_MODEL_NB.config.aspect_ratioOptions}
                    />
                </FlexItem>
            </Flex>

            <p> This model typically takes only a few seconds to complete.</p>
 
            <div style={{ display: 'flex', justifyContent: 'flex-end', marginBottom: '1rem' }}>
                <GenerateAbortButtons disabled={!canGenerate} cost={IMG2IMG_MODEL_NB.config.costPerOutput * modelState.input.num_images}  />
            </div>


        </>
    );
}




