//@ts-ignore
import { TextareaControl, Button, Flex, FlexItem, ToggleControl} from '@wordpress/components';
import { useImg2VidContext, useToolsContext } from '../../../ContextProvider';

import InputImagesControl from '../../../to-be-shared/InputImageControl';

import { IMG2VID_MODEL_KDP } from '../../../constants'
import type { Img2VidModelContextKdp } from '../../../types';
import GenerateAbortButtons from '../../../GenerateAbortButtons';

export default function ModelDisplayKdp() {
    const { progress } = useToolsContext();
    const { models  } = useImg2VidContext();

    const modelKdp = models.find(model => model.id === 'kdp')!;
    const modelState = modelKdp.modelState;
    const setModelState = modelKdp.setModelState;

    // Determine if we can generate
    const canGenerate = Boolean(modelState.input.image_url && modelState.input.prompt);

    return (
        <>
            <InputImagesControl
                label={IMG2VID_MODEL_KDP.config.image_urlLabel}
                progress={progress}

                imageS3Url={modelState.input.image_url}

                onUploadFinished={(s3Url: string, fileName: string) => {
                    console.log('ModelDisplayKdp handleUploadComplete() s3Urls:', s3Url);
                    setModelState( ( prev : Img2VidModelContextKdp ) : Img2VidModelContextKdp => ( {
                        ...prev,
                        input: {
                            ...prev.input,
                            image_url: s3Url
                        }
                    }));
                }}
                onRemove={() => {
                    console.log('ModelDisplayKdp handleRemoveMedia() ');
                    setModelState( ( prev : Img2VidModelContextKdp ) : Img2VidModelContextKdp => ( {
                        ...prev,
                        input: {
                            ...prev.input,
                            image_url: ''
                        }
                    }));
                }}
            />
            <TextareaControl
                label="Prompt"
                value={modelState.input.prompt}
                onChange={(newPrompt: string) => {
                    setModelState( ( prev : Img2VidModelContextKdp ) : Img2VidModelContextKdp => ( {
                        ...prev,
                        input: {
                            ...prev.input,
                            prompt: newPrompt
                        }
                    }));
                }}
                rows={3}
            />
            <TextareaControl
                label="Negative Prompt"
                value={modelState.input.negative_prompt}
                onChange={(newNegativePrompt: string) => {
                    setModelState( ( prev : Img2VidModelContextKdp ) : Img2VidModelContextKdp => ( {
                        ...prev,
                        input: {
                            ...prev.input,
                            negative_prompt: newNegativePrompt
                        }
                    }));
                }}
                rows={1}
            />
            {/*
                TODO:
            - duration (in seconds) => or i can simplify to 10 seconds only => dependent on price to have a flat price per video.
                - challenge: price per video needs to be priced per video second or stg like that (API side)

            */}

            <p>This model creates 10 seconds long clips. Job completes in around 2-3 minutes.</p>

            <div style={{ display: 'flex', justifyContent: 'flex-end', marginBottom: '1rem' }}>
                <GenerateAbortButtons disabled={!canGenerate} cost={IMG2VID_MODEL_KDP.config.costPerOutput} />
            </div>

        </>
    );
}




