import { useState } from "react";


import type { Img2VidModelIds, ToolImg2VidContextState, Img2VidModelContextHlo, Img2VidModelContextKdp  } from "../../types";
import { IMG2VID_MODEL_INITIAL_STATE_HLO, IMG2VID_MODEL_INITIAL_STATE_KDP } from "../../constants";

// State hook
export function useImg2VidState(): ToolImg2VidContextState {
  // Current model
  const [ currentModelId, setCurrentModelId ] = useState<Img2VidModelIds>("hlo");

  // State for each model
  const [ modelStateHlo, setModelStateHlo ] = useState<Img2VidModelContextHlo>(IMG2VID_MODEL_INITIAL_STATE_HLO);
  const [ modelStateKdp, setModelStateKdp ] = useState<Img2VidModelContextKdp>(IMG2VID_MODEL_INITIAL_STATE_KDP );

  return {
    id: 'img2vid',
    currentModelId, 
    setCurrentModelId,
    models: [
      {
        id: 'hlo',
        modelState: modelStateHlo, 
        setModelState: setModelStateHlo,
      },
      {
        id: 'kdp',
        modelState: modelStateKdp, 
        setModelState: setModelStateKdp,
      }
    ]
  };
}
