//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Dropdown, ToolbarButton } from '@wordpress/components';
import {
    BlockControls,
    __experimentalLinkControl as LinkControl
    //@ts-ignore
} from '@wordpress/block-editor';
import { AttributesCanvas3d } from '../../types';
import FullSizeButton from '../../../../components/block-controls-canvasxd/FullSizeButton';
import ButtonSceneWrapper from '../../../../components/canvasxd/ButtonSceneWrapper';
                
export default function BlockControlsCanvas2d({
    clientId,
    attributes, 
    setAttributes,
    defaultAttributes,
}:{
    clientId: string,
    attributes: AttributesCanvas3d 
    setAttributes: any,
    defaultAttributes:any
}){
    return (
        <>
            <BlockControls group="block">
                <FullSizeButton
                    attributes={ attributes }
                    setAttributes={ setAttributes }
                    defaultAttributes={ defaultAttributes }
                    // isActive={ isFullSize }
                    // onToggle={ toggleFullHeight }
                />
                <ButtonSceneWrapper clientId={clientId} />
            </BlockControls>
            
            <BlockControls group={ true ? 'inline' : 'other' }>
                <Dropdown
                    className="scroll-sequence-dropdown-replace-spline-url"
                    contentClassName="scroll-sequence-dropdown-replace-spline-url-content"
                    popoverProps={ { placement: 'bottom-start' } }
                    renderToggle={ ( { isOpen, onToggle }:any ) => (
                        <ToolbarButton
                            aria-expanded={ isOpen }
                            aria-haspopup="true"
                            onClick={ onToggle }
                            //onKeyDown={ openOnArrowDown }
                        >
                            Replace
                        </ToolbarButton>
                    ) }
                    renderContent={ () => (
                        <>
                            <span>
                                <span>Replace Spline URL</span><br/>
                                <span>Paste the new URL of the .splinecode</span>
                            </span>
                            <LinkControl
                                value={ { url: attributes.splinecodeurl } }
                                settings={ [] }
                                showSuggestions={ false }
                                onChange={ (url : {url:string} ) => {
                                    setAttributes({splinecodeurl: url.url})
                                }}
                                searchInputPlaceholder={ __(
                                    'https://prod.spline.design/{my_hash}/scene.splinecode'
                                ) }
                            />
                        </>
                    ) }
                />
            </BlockControls>
        </>
    )
}