//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
import {  useEffect, useRef, useState } from '@wordpress/element'
//@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
import { useBlockProps, useInnerBlocksProps, store as blockEditorStore, } from '@wordpress/block-editor';
//@ts-ignore: Cannot find module '@wordpress/data' or its corresponding type declarations.
import { useSelect } from '@wordpress/data';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Placeholder, TextControl, Button } from '@wordpress/components'
import { 
    __experimentalLinkControl as LinkControl
    //@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
} from '@wordpress/block-editor';
import { AttributesCanvas3d } from '../types';


import InspectorControls from './inspector-controls';
import BlockControls from './block-controls';
import { IconCanvas3d } from '../../../../icons'
import getScrollsequenceFop from '../../../getScrollsequenceFop';
import { DC3D } from '../../../../dbg'
import { DEFAULT_SPLINECODEURL } from '../constants'
/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {WPElement} Element to render.
 */
interface EditProps {
    clientId: string,
    attributes: AttributesCanvas3d,
    setAttributes: any,
    name: string,
    onRemove: any, //  () => removeBlock(clientId)
    onReplace: any, //  (...args) => {…}
    // ... more attributes
    
}
export default function Edit(props:EditProps) {

    const { 
        clientId,
        attributes, 
        setAttributes,
        attributes:{
            splinecodeurl,
            //... more attributes
        }, 
        onRemove,
        onReplace,
    } = props;

    const defaultAttributes = useSelect((select:any) => { // Access the default values
        return select('core/blocks').getBlockType('scroll-sequence/v2-canvas3d').attributes
    }, []); //console.log('defaultAttributes',defaultAttributes)

    // Assign width and height with default values if not set - (this happens in three places. editor, editor component and front end render.php)
    const width = attributes.width ? attributes.width : '100';
    const widthUnit = attributes.widthUnit ? attributes.widthUnit : '%';
    const isAutoWidth = (widthUnit === 'auto') ? true : false;

    const height = attributes.height ? attributes.height : '75';
    const heightUnit = attributes.heightUnit ? attributes.heightUnit : 'vh';

    const elRef = useRef<any>(null)
    const blockProps = useBlockProps({
        style: {
            width:  isAutoWidth ? undefined : `${ width }${ widthUnit }`,
            height: `${ height }${ heightUnit }`,
        },
        //className: `ssq-relative`
        ref: elRef
    });

   
    useEffect(() => {
        DC3D&&console.log('canvas3d useEffect[attributes] elRef.current.id',elRef.current?.id)
        getScrollsequenceFop(elRef.current)?.createBlock(elRef.current);

        return () => {
            DC3D&&console.log('canvas3d useEffect[attributes] CLEANUP elRef.current.id',elRef.current?.id)
            getScrollsequenceFop(elRef.current)?.destroyBlock(elRef.current)
        };
    }, [attributes]);	

    return (
        <>
            <BlockControls
                clientId={clientId}
                attributes={attributes} 
                setAttributes={setAttributes} 
                defaultAttributes={defaultAttributes}
            />         
          
            <InspectorControls 
                attributes={attributes} 
                setAttributes={setAttributes} 
                defaultAttributes={defaultAttributes} 
                elRef={elRef}
            />        

            { splinecodeurl 
            ?
                <div {...blockProps} data-ssq-canvas3d={JSON.stringify(attributes)}  >
                    <canvas></canvas>
                </div>
            :		
                <div {...blockProps}>
                    <Placeholder
                        icon={ IconCanvas3d }
                        instructions={__('Enter Spline code URL','scrollsequence')}
                        label={__('Canvas 3D ','scrollsequence')}
                    >
                                <span>
                                    <span>{__('Paste the new URL of the .splinecode in the sidebar','scrollsequence')}</span>
                                    <br/>
                                    <br/>Example: <i>{DEFAULT_SPLINECODEURL}</i>
                                    <br/>
                                    <Button variant="secondary" style={{marginTop:"1rem"}} onClick={()=>{setAttributes({splinecodeurl:DEFAULT_SPLINECODEURL})}}>Apply</Button>
                                    <br/><br/>
                                </span>
                                {/* <LinkControl
                                    value={ { url: '' } }
                                    settings={ [] }
                                    showSuggestions={ false }
                                    onChange={ (url : any ) => {
                                        console.log('url',url)
                                        //setAttributes({splinecodeurl: url.url})
                                    }}
                                    searchInputPlaceholder='https://prod.spline.design/{my_hash}/scene.splinecode'
                                    
                                /> */}

                    </Placeholder>	
                </div>
            }        

        
        </>
    )
}