//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
import { 
    InspectorControls, 
    BlockControls,
    __experimentalLinkControl as LinkControl
    //@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
} from '@wordpress/block-editor';
import { 
    Button,
    Dropdown,
    Panel, 
    PanelBody, 
    TextareaControl ,
    CheckboxControl ,
    ExternalLink ,
    Notice,
    //@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
} from '@wordpress/components'

import ScrollTriggerControlBlocks from '../../../../components/ScrollTriggerControlBlocks'
//import PinControl from '../../../../components/PinControl'
import { AttributesCanvas3d } from '../../types';
import WidthInput from '../../../../components/canvasxd/WidthInput';
import HeightInput from '../../../../components/canvasxd/HeightInput';
import getHrefUpgrade from '../../../../getHrefUpgrade';

declare const wp: any; 
const { applyFilters, } = wp.hooks;

// function getEditUrlFromSplinecodeUrl( splinecodeurl:string ){
//     if ( !splinecodeurl ) {
//         return undefined;
//     }
//     const url = new URL( splinecodeurl );
//     const urlArray = url.pathname.split('/')
    
//     const hash = urlArray[Math.max(0, urlArray.length - 2)]
//     console.log('urlArray:',urlArray, 'hash:',hash)
//     return `https://app.spline.design/file/${hash}`;
// }

export default function InspectorControlsCanvas({
    attributes, 
    setAttributes, 
    defaultAttributes, 
    elRef,
}:{
    attributes: AttributesCanvas3d
    setAttributes: any
    defaultAttributes: any 
    elRef: any
}){
    const { 
        width, 
        widthUnit,
        height, 
        heightUnit, 
        splinecodeurl,
        splineediturl,
        variables,
    } = attributes


    const PlanF = applyFilters('scroll-sequence-test3d', <div style={{border: "1px solid yellow"}}>Free (3dv2)</div> );

    //console.log('splinecodeurl:',splinecodeurl,'editUrl:', getEditUrlFromSplinecodeUrl( splinecodeurl ) )
    
    return (
        <>
            <InspectorControls>
                <Panel>
                    <div style={{margin:"10px", }}>
                        <CheckboxControl
                        __nextHasNoMarginBottom
                        checked={ attributes.isStoppedInEditor ? attributes.isStoppedInEditor : false }
                        label={__("Stop in Editor", "scrollsequence")}
                        help={__("Stop animation in editor to improve editor performance", "scrollsequence")}
                        onChange={ () => setAttributes( {isStoppedInEditor: ! attributes.isStoppedInEditor } ) }
                        />                    
                    
                        {/* <PanelBody title={__('Spline URL', 'scrollsequence')} initialOpen={true}> */}
                        <TextareaControl 
                            __nextHasNoMarginBottom
                            label="Spline code URL"
                            value={ splinecodeurl }
                            disabled = {true}
                            rows={ 2 }
                        />

                        <Dropdown
                            className="scroll-sequence-dropdown-replace-spline-url"
                            contentClassName="scroll-sequence-dropdown-replace-spline-url-content"
                            popoverProps={ { placement: 'bottom-start' } }
                            renderToggle={ ( { isOpen, onToggle }:any ) => (
                                <Button
                                    //aria-expanded={ isOpen }
                                    //aria-haspopup="true"
                                    onClick={ onToggle }
                                    //onKeyDown={ openOnArrowDown }
                                    variant="secondary"
                                >
                                    Replace
                                </Button>
                            ) }
                            renderContent={ () => (
                                <>
                                    <span>
                                        <span>Replace Spline URL</span><br/>
                                        <span>Paste the new URL of the .splinecode</span>
                                    </span>
                                    <LinkControl
                                        value={ { url: attributes.splinecodeurl } }
                                        settings={ [] }
                                        showSuggestions={ false }
                                        onChange={ (url : {url:string} ) => {
                                            setAttributes({splinecodeurl: url.url})
                                        }}
                                        searchInputPlaceholder={ __(
                                            'https://prod.spline.design/{my_hash}/scene.splinecode'
                                        ) }
                                    />
                                </>
                            ) }
                        />                   
                    </div>


                    {/* </PanelBody> */}
                    <PanelBody title={__('Variables', 'scrollsequence')} initialOpen={true} >
                        {applyFilters('scrollsequence-c3d-variables-control',(
                            <Panel>
                                {/* <Notice status="error"> */}
                                    <p>
                                        To control spline variables from Scrollsequence, please <a href={getHrefUpgrade()} target="_blank" >upgrade</a> to a Premium plan.
                                    </p>
                                {/* </Notice> */}
                            </Panel>
                        ), attributes, setAttributes, elRef)}
                    </PanelBody>
                </Panel>
                <Panel>
                    <PanelBody title={__("Animation Trigger", "scrollsequence")} initialOpen={true}>
                        <ScrollTriggerControlBlocks attributes={attributes} setAttributes={setAttributes} defaultAttributes={defaultAttributes} />
                    </PanelBody>
                </Panel>
                {/* <Panel>
                    <PanelBody title={__("Pinning", "scrollsequence")} initialOpen={false}>
                        <PinControl attributes={attributes} setAttributes={setAttributes} defaultAttributes={defaultAttributes} />
                    </PanelBody>
                </Panel>  */}

                <Panel>
                    <PanelBody title={__("Debug", "scrollsequence")} initialOpen={false}>
                        <p>Attributes:</p>
                        <pre>{JSON.stringify(attributes, null, 2)}</pre>
                        <p>Plan (filter):</p>
                        {PlanF}
                    </PanelBody>
                </Panel>        
            </InspectorControls>

            {/* <InspectorControls group="color">
                ____Color_____
            </InspectorControls> */}

            <InspectorControls group="dimensions">

                {/* DEFFAULTS: (this happens in three places. editor, editor component and front end render.php) */ }
                <WidthInput
                    value={ width ? width : '100'}
                    unit={ widthUnit ? widthUnit : '%'}
                    onChange={ ( newwidth:any ) =>
                        setAttributes( {
                            width: newwidth,
                        } )
                    }
                    onUnitChange={ ( nextUnit:any ) =>
                        setAttributes( {
                            widthUnit: nextUnit,
                        } )
                    }
                />                    
                <HeightInput
                    value={ height ? height : '75'}
                    unit={ heightUnit ? heightUnit : 'vh'}
                    onChange={ ( newheight:any ) =>
                        setAttributes( {
                            height: newheight,
                        } )
                    }
                    onUnitChange={ ( nextUnit:any ) =>
                        setAttributes( {
                            heightUnit: nextUnit,
                        } )
                    }
                />
            
            </InspectorControls>

            {/* <InspectorControls group="advanced">
                    TADY SE DAVAL TEN ELEMENT SELECT
            </InspectorControls> */}
        </>
    )
}
