<?php
/**
 * PHP file to use when rendering the block type on the server to show on the front end.
 *
 * The following variables are exposed to the file:
 *     $attributes (array): The block attributes.
 *     $content (string): The block default content.
 *     $block (WP_Block): The block instance.
 *
 * @see https://github.com/WordPress/gutenberg/blob/trunk/docs/reference-guides/block-api/block-metadata.md#render
 */

// PHP  (this happens in three places. editor, editor component and front end render.php)
$width = isset($attributes['width']) ? $attributes['width'] : '100';
$widthUnit = isset($attributes['widthUnit']) ? $attributes['widthUnit'] : '%';
$isAutoWidth =  $widthUnit === 'auto' ? true : false;

$height = isset($attributes['height']) ? $attributes['height'] : '75';
$heightUnit = isset($attributes['heightUnit']) ? $attributes['heightUnit'] : 'vh';


// Initialize extra attributes for the wrapper div
$scroll_sequence_extra_attributes = [
    'class' => 'ssq-not-hydrated',
	'style' => 'height:'.$height.$heightUnit.';'.( $isAutoWidth ? 'width:auto;' : 'width:'.$width.$widthUnit.';' ),

];

// remove isStoppedInEditor from attributes to prevent it from being passed to the canvas3d element
unset($attributes['isStoppedInEditor']);

?>

<div 
    <?php echo wp_kses_data( get_block_wrapper_attributes($scroll_sequence_extra_attributes) ); ?>  
    data-ssq-canvas3d='<?php echo wp_json_encode($attributes);?>' 
>
    <?php /* PRELOAD splinecode - TODO: this should be tested if it improves anything .. */ ?> 
    <link rel="preload" href="<?php echo esc_url($attributes['splinecodeurl'])?>" as="fetch" crossorigin="anonymous"/>

    <canvas></canvas>
</div>

