//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/element' or its corresponding type declarations.
import { useState } from '@wordpress/element';
import {
	BlockControls,
	__experimentalBlockAlignmentMatrixControl as BlockAlignmentMatrixControl,
	__experimentalBlockFullHeightAligmentControl as FullHeightAlignmentControl,
	//@ts-ignore
} from '@wordpress/block-editor';


import { AttributesScene } from '../../types';
import { DVPT } from '../../../../../dbg';
import ChatButton from '../../../../components/block-controls-canvasxd/ChatButton';




export default function BlockControlsScene({
    clientId,
    attributes, 
    setAttributes,
    defaultAttributes,
    hasInnerBlocks,
}:{
    clientId: string,
    attributes: AttributesScene
    setAttributes: any
    defaultAttributes: any
    hasInnerBlocks: boolean
}){
    // HEIGHT 
	const { height, heightUnit } = attributes;
    const [ prevHeightValue, setPrevHeightValue ] = useState( height );
    const [ prevHeightUnit, setPrevHeightUnit ] =
        useState( heightUnit );
    const isFullHeight =
        heightUnit === 'vh' &&
        height === 100 &&
        ! attributes?.style?.dimensions?.aspectRatio;
    const toggleMinFullHeight = () => {
        if ( isFullHeight ) {
            // If there aren't previous values, take the default ones.
            if ( prevHeightUnit === 'vh' && prevHeightValue === 100 ) {
                DVPT&&console.log('defaultAttributes',defaultAttributes)
                return setAttributes( {
                    height: defaultAttributes.height.default,
                    heightUnit: defaultAttributes.heightUnit.default,
                } );
            }

            // Set the previous values of height.
            return setAttributes( {
                height: prevHeightValue,
                heightUnit: prevHeightUnit,
            } );
        }

        setPrevHeightValue( height );
        setPrevHeightUnit( heightUnit );

        // Set full height, and clear any aspect ratio value.
        return setAttributes( {
            height: 100,
            heightUnit: 'vh',
        } );
    };


    return (
        <>
            <BlockControls>
                <ChatButton clientId={clientId} />
            </BlockControls>
            <BlockControls group="block">

                <FullHeightAlignmentControl
                    isActive={ isFullHeight }
                    onToggle={ toggleMinFullHeight }
                    isDisabled={ ! hasInnerBlocks }
                />
            </BlockControls>
        </>
    )
}