import type { AttributesScene } from '../types';

type RenderFunctionResult = 
    undefined | // in case there is an error with the attributes, returns undefined
    {
        bp:  // blockProps => OUTERMOST div
            { 
                class: string;
                style: React.CSSProperties;
            }
        mid?: // Middle div (OPTIONAL)
            { 
                class: string;
                style: React.CSSProperties; // We need a string for inline styles
            } 
        ibp: // innerBlocksProps => INNERMOST div
            { 
                class: string;
                style: React.CSSProperties;
            } 
    }
    



export default function RenderFunction({
    attributes,
    heightWithUnit, 
    durationWithUnit, 
    topWithUnit,
    absTopWithUnit

}:{
    attributes:AttributesScene
    heightWithUnit: string;
    durationWithUnit: string;
    topWithUnit: string;
    absTopWithUnit: string;    
}): RenderFunctionResult {
    if (attributes.scenePosition ==='sticky'){ 
        if(attributes.sendBehindContent  === false){ // FG
            return { // ssq_sticky_js_fg_spacing/nospacing
                bp: { 
                    class: 'ssq-relative ', // ssq-border-green
                    style: { 
                        height: 
                            attributes.stickySpacing
                            ?   `calc( ${heightWithUnit} + ${durationWithUnit}`
                            :  heightWithUnit, 
                    }
                }, 
                //mid: undefined,
                ibp: {  // if no spacing, this element does not exist on frontend
                    class: 'scroll-sequence-v2-scene_inner', //ssq-border-green-dashed
                    style: { height: heightWithUnit }
                }
            }                
        }
        if(attributes.sendBehindContent  === true){ // BG
            return { // ssq_sticky_js_bg
                bp: { 
                    class: 'ssq-pointer-events-none',//ssq-border-purple // ssq-absolute does not work in editor, it gets overwritten, that's why it is in style here. 
                    style: { left:0, width: '100%', top: absTopWithUnit, position: 'absolute'  }
                }, 
                //mid: undefined,
                ibp: { 
                    class: 'scroll-sequence-v2-scene_inner ssq-relative', //ssq-border-green
                    style: { height: heightWithUnit }
                }
            }    
        }
    }
    if (attributes.scenePosition ==='fixed'){
        if(attributes.sendBehindContent === false){ // FG
            return { // ssq_fixed_fg
                bp: { 
                    class: 'ssq-relative',  //  ssq-border-green
                    style: { height: `calc( ${heightWithUnit} + ${durationWithUnit}`, }
                }, 
                //mid: undefined,
                ibp: { 
                    class: 'scroll-sequence-v2-scene_inner ssq-fixed', // ssq-border-green-dashed
                    style: { height: heightWithUnit, inset: 0, top: topWithUnit }
                }
            }               
        }
        if(attributes.sendBehindContent === true){ // BG
            return { // ssq_fixed_bg
                bp: { 
                    class: 'ssq-pointer-events-none', // ssq-border-purple  // ssq-absolute does not work in editor, it gets overwritten, that's why it is in style here. 
                    style: { left:0, width: '100%', top: absTopWithUnit, position: 'absolute'  }
                }, 
                mid: {
                    class: 'scroll-sequence-v2-scene_mid ssq-relative', //  ssq-border-green
                    style: { height: `calc( ${heightWithUnit} + ${durationWithUnit}`, }
                },
                ibp: { 
                    class: 'scroll-sequence-v2-scene_inner ssq-fixed', //  ssq-border-green-dashed
                    style: { height: heightWithUnit, inset: 0, top: topWithUnit }
                }
            }                
        }
    }
    return undefined;
}