/**
 * WordPress dependencies
 */
//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
import { cover , pin, tablet} from '@wordpress/icons';
import { IconScenePin, IconSceneSticky } from '../../../icons';
/**
 * 
 * The variations are referenced in
 * - block.json 
 * - index (imported and used in registerBlockType)
 * - types.ts 
 * 
 */

const variations = [
	{
		name: 'scroll-sequence/v2-scene-sticky',
		title: __( 'Scene Sticky', 'scrollsequence' ),
		description: __( 'Scrollsequence - Scene Sticky ', 'scrollsequence' ),
		attributes: { scenePosition: 'sticky', stickyType: 'css' },
		isDefault: true,
		isActive: [ 'scenePosition' ],
		icon: IconScenePin,
	},    
	{
		name: 'scroll-sequence/v2-scene-fixed',
		title: __( 'Scene Fixed', 'scrollsequence' ),
		description: __( 'Scrollsequence - Scene Fixed', 'scrollsequence' ),
		attributes: { scenePosition: 'fixed',  },
		isDefault: false,
		isActive: [ 'scenePosition' ],
		icon: IconSceneSticky,
	}
];

export default variations;