//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Panel, PanelBody, PanelRow, ToggleControl, RangeControl  } from '@wordpress/components'

/**
 * 
 * 
 * 	 PIN CONTROL WAS USED IN C1D, C2D AND C3D BLOCKS. BUT REALLY IT IS NOT REQUIRED (on canvases ), BECAUSE WE HAVE SCENE BLOCKS INSTEAD.
 *  We may use it on content pinning for "non scene" content blocks. 
 * 
 * 
 * 
 */

export default function PinControlHocs({
    attributes, 
    setAttributes, 
}: {
    attributes: {
        ssqAnimateOnScroll?:{
            to?: any, 
            st?: {
                // triggerStart?: number,
                // triggerEnd?: number,
                // scrub?: number,
                // markers?: boolean
				pin?: boolean,
				pinMarkers?: boolean,
				pinSpacing?: boolean,
				pinTriggerStart?: number,
				pinTriggerEnd?: number


            }
        }
    },
    setAttributes: any
}){

	const pinDefault = false 
	const pinMarkersDefault = false;
	const pinSpacingDefault = false;
	const pinTriggerStartDefault = 0.5
	const pinTriggerEndDefault = 0.5

    return (
		<>
            <PanelRow>
                <ToggleControl
                    __nextHasNoMarginBottom
                    label={__("Pin", "scrollsequence")}
                    checked={ attributes.ssqAnimateOnScroll?.st?.pin || pinDefault }
                    onChange={ () => {
                        setAttributes({
                            ssqAnimateOnScroll: {
                                ...attributes.ssqAnimateOnScroll,
                                st: {
                                    ...attributes.ssqAnimateOnScroll?.st,
                                    pin: !attributes.ssqAnimateOnScroll?.st?.pin
                                }
                            }
                        });
					}}
                />
            </PanelRow>
            {attributes.ssqAnimateOnScroll?.st?.pin &&
                <>
					<PanelRow>
						<ToggleControl
							__nextHasNoMarginBottom
							label={__("Show Pin Markers", "scrollsequence")}
							checked={ attributes.ssqAnimateOnScroll?.st?.pinMarkers || pinMarkersDefault }
							onChange={ () => {
								setAttributes({
									ssqAnimateOnScroll: {
										...attributes.ssqAnimateOnScroll,
										st: {
											...attributes.ssqAnimateOnScroll?.st,
											pinMarkers: !attributes.ssqAnimateOnScroll?.st?.pinMarkers
										}
									}
								});
							}}
						/>
					</PanelRow>     











                    <PanelRow>
                        <ToggleControl
                            __nextHasNoMarginBottom
                            label={__("Pin Spacing", "scrollsequence")}
                            checked={ attributes.ssqAnimateOnScroll?.st?.pinSpacing || pinSpacingDefault }
                            onChange={ () => {
                                setAttributes({
                                    ssqAnimateOnScroll: {
                                        ...attributes.ssqAnimateOnScroll,
                                        st: {
                                            ...attributes.ssqAnimateOnScroll?.st,
                                            pinSpacing: !attributes.ssqAnimateOnScroll?.st?.pinSpacing
                                        }
                                    }
                                });
                            }}
                        />
                    </PanelRow>	
					<PanelRow>
						<RangeControl
							__nextHasNoMarginBottom
							help={__("Please select how early you want the pin to start.", "scrollsequence")}
							initialPosition={attributes.ssqAnimateOnScroll?.st?.pinTriggerStart || pinTriggerStartDefault}
							label={__("Pin Start", "scrollsequence")}
							min={0}
							max={1}
							step={0.01}
							onChange={(value: number) => { 
								setAttributes({
									ssqAnimateOnScroll: {
										...attributes.ssqAnimateOnScroll,
										st: {
											...attributes.ssqAnimateOnScroll?.st,
											pinTriggerStart: value
										}
									}
								});
							}}
							allowReset={true}
							resetFallbackValue={pinTriggerStartDefault}			
							marks={[
								{
								  label: '',
								  value: pinTriggerStartDefault
								}
							]}							
						/>
					</PanelRow>
					<PanelRow>
						<RangeControl
							__nextHasNoMarginBottom
							help={__("Please select how late you want the pin to finish.", "scrollsequence")}
							initialPosition={attributes.ssqAnimateOnScroll?.st?.pinTriggerEnd || pinTriggerEndDefault}
							label={__("Pin End", "scrollsequence")}
							min={0}
							max={1}
							step={0.01}
							onChange={(value: number) => {
								setAttributes({
									ssqAnimateOnScroll: {
										...attributes.ssqAnimateOnScroll,
										st: {
											...attributes.ssqAnimateOnScroll?.st,
											pinTriggerEnd: value
										}
									}
								});
							}}
							allowReset={true}
							resetFallbackValue={pinTriggerEndDefault}			
							marks={[
								{
								  label: '',
								  value: pinTriggerEndDefault
								}
							]}							
						/>						
					</PanelRow>
                </>
            }
		</>
    )
}