//@ts-ignore:
import { SelectControl } from '@wordpress/components';

// used on HOCS and Canvas blocks 
export default function PointerEventsSelect({attributes, setAttributes}:any) {
    const { ssqPointerEvents } = attributes;
    return (
        <SelectControl
            label="Pointer Events"
            value={ ssqPointerEvents }
            options={ [
                { label: '"auto" (default)', value: 'auto' },
                { label: '"none" (non-interactive)', value: 'none' },
            ] }
            onChange={ ( newSize: string | false ) => {
                console.log('PointerEventsSelect onChange newSize:', newSize);
                if ( newSize === 'auto' ) {
                    setAttributes({
                        ssqPointerEvents: undefined,
                    });
                } else {
                    setAttributes({
                        ssqPointerEvents: newSize,
                    });
                }

            }}
            __next40pxDefaultSize
            __nextHasNoMarginBottom
        />
    )
}