//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Panel, PanelBody, PanelRow, ToggleControl, RangeControl } from '@wordpress/components'

export default function ScrollTriggerControlBlocks({attributes, setAttributes, defaultAttributes}: any){
    return (
		<>
			{/* <div>Element: This | Parent Element ...</div>  */}

			<PanelRow>
				<ToggleControl
					__nextHasNoMarginBottom
					label={__("Show Markers", "scrollsequence")}
					checked={ attributes.markers }
					onChange={ () => setAttributes({markers:!(attributes.markers)}) }
				/>
			</PanelRow>
								
			<PanelRow>
				<RangeControl
					__nextHasNoMarginBottom
					help={__("Please select how early you want the animation to start.", "scrollsequence")}
					initialPosition={attributes.triggerStart}
					label={__("Trigger Start", "scrollsequence")}
					min={0}
					max={1}
					step={0.01}
					onChange={(e: number) => { 
						setAttributes({triggerStart:(e)})
					}}
					allowReset={true}
					resetFallbackValue={defaultAttributes.triggerStart.default}			
					marks={[
						{
							label: '',
							value: defaultAttributes.triggerStart.default
						}
					]}							
				/>
			</PanelRow>
			<PanelRow>
				<RangeControl
					__nextHasNoMarginBottom
					help={__("Please select how late you want the animation to finish.", "scroll-sequence")}
					initialPosition={attributes.triggerEnd}
					label={__("Trigger End", "scroll-sequence")}
					min={0}
					max={1}
					step={0.01}
					onChange={(e:number) => { 
						setAttributes({triggerEnd:(e)})
					}}
					allowReset={true}
					resetFallbackValue={defaultAttributes.triggerEnd.default}			
					marks={[
						{
							label: '',
							value: defaultAttributes.triggerEnd.default
						}
					]}							
				/>						
			</PanelRow>
			<PanelRow>
				<RangeControl
					__nextHasNoMarginBottom
					help={__("Please select how smooth you want your animation.", "scrollsequence")}
					initialPosition={attributes.scrub}
					label={__("Smoothness (delay in seconds)", "scrollsequence")}
					min={0}
					max={5}
					step={0.01}
					onChange={(e:number) => { 
						setAttributes({scrub:e})
					}}
					allowReset={true}
					resetFallbackValue={defaultAttributes.scrub.default}		
					marks={[
						{
							label: '',
							value: defaultAttributes.scrub.default
						}
					]}					
				/>
			</PanelRow>
		</>
    )
}