//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/element' or its corresponding type declarations.
import { useState } from '@wordpress/element';
import {
	BlockControls,
	//__experimentalBlockFullHeightAligmentControl as FullHeightAlignmentControl,
	//@ts-ignore
} from '@wordpress/block-editor';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { ToolbarButton } from '@wordpress/components';
import { fullscreen } from '@wordpress/icons';

import {  AttributesCanvas1d } from '../../blocks/canvas1d/types';
import {  AttributesCanvas2d } from '../../blocks/canvas2d/types';
import {  AttributesCanvas3d } from '../../blocks/canvas3d/types';
//import FullSize from './FullSize';
//import cleanEmptyObject from '../../../utils/cleanEmptyObject'


export default function FullSizeButton({
    attributes, 
    setAttributes,
    defaultAttributes,
}:{
    attributes: AttributesCanvas1d | AttributesCanvas2d | AttributesCanvas3d
    setAttributes: any,
    defaultAttributes:any
}){
	const { width, widthUnit, height, heightUnit } = attributes;

    const [ prevWidthValue, setPrevWidthValue ] = useState( width );
    const [ prevWidthUnit, setPrevWidthUnit ] = useState( widthUnit );

    const [ prevHeightValue, setPrevHeightValue ] = useState( height );
    const [ prevHeightUnit, setPrevHeightUnit ] = useState( heightUnit );

    //const [ prevAlign, setPrevAlign ] = useState( align ); // in some nested scenarios, align is not there and does not have an effect.


    const isFullSize = width === 100 && widthUnit === '%' &&  height === 100 && heightUnit === 'vh';

    const toggleFullHeight = () => {
        console.log('defaultAttributes,',defaultAttributes)
        if ( isFullSize ) {
            // If there aren't previous values, take the default ones.
            if ( prevHeightUnit === 'vh' && prevHeightValue === 100 ) {
                return setAttributes( {
                    width: defaultAttributes.width.default,
                    widthUnit: defaultAttributes.widthUnit.default,
                    
                    height: defaultAttributes.height.default,
                    heightUnit: defaultAttributes.heightUnit.default,
                } );
            }

            // Set the previous values of height.
            return setAttributes( {
                width: prevWidthValue,
                widthUnit: prevWidthUnit,   

                height: prevHeightValue,
                heightUnit: prevHeightUnit,

            } );
        }

        setPrevWidthValue( width );
        setPrevWidthUnit( widthUnit );
        setPrevHeightValue( height );
        setPrevHeightUnit( heightUnit );

        // Set full height, and clear any aspect ratio value.
        console.log('set full size!')
        return setAttributes( {
            width: 100,
            widthUnit: '%',

            height: 100,
            heightUnit: 'vh',

         } );
    };

    return (
        <ToolbarButton
            isActive={ isFullSize }
            icon={ fullscreen }
            label={ __( 'Full size', 'scrollsequence' ) }
            onClick={ () => toggleFullHeight() }
            disabled={ false }
        />
    );
}

