const defaultConfig = require( '@wordpress/scripts/config/webpack.config' );
const path = require( 'path' );

// see: https://stackoverflow.com/questions/56284260/is-it-possible-in-webpack-to-have-multiple-subdirectory-entry-points-with-multip

console.log('WEBPACK.CONFIG ')
console.warn('v2/webpack.config.js - If you are building or starting the FREE version, please remove the premium blocks from the webpack config entry object. Premium files are not distributed in the free version! ')

module.exports =  {
  ...defaultConfig,
  entry: {
      // Dashboard
      "dashboard":   __dirname + '/src/dashboard/index.tsx', 
      // *** V2 ***
      'v2/blocks/view':   __dirname + '/src/v2/blocks/view.ts',

      // canvas
      'v2/blocks/canvas1d/index':   __dirname + '/src/v2/blocks/canvas1d/index.tsx', 
      'v2/blocks/canvas2d/index':   __dirname + '/src/v2/blocks/canvas2d/index.tsx', 
      'v2/blocks/canvas3d/index':   __dirname + '/src/v2/blocks/canvas3d/index.tsx', 

      // container
      'v2/blocks/container/index':   __dirname + '/src/v2/blocks/container/index.tsx', 
      // scene
      'v2/blocks/scene/index':   __dirname + '/src/v2/blocks/scene/index.tsx',    

      // hocs
      'v2/hocs/index':   __dirname + '/src/v2/hocs/index.tsx',

      // Premium
      'premium/blocks/extend-blocks':   __dirname + '/src/premium/blocks/extend-blocks.tsx',
      'premium/blocks/view-premium':   __dirname + '/src/premium/blocks/view-premium.ts', // is really the same, but want to make it separate    

  },
  output: {
      path: __dirname + "/build",
      filename: "[name].js"
  },
  // TYPESCRIPT https://makeitwork.press/typescript-with-wordpress/
  module: {
      ...defaultConfig.module,
      rules: [
        ...defaultConfig.module.rules,
        {
          test: /\.tsx?$/,
          use: [
            {
              loader: 'ts-loader',
              options: {
                configFile: 'tsconfig.json',
                transpileOnly: true,
              }
            }
          ]        
        }
      ]
  },
  resolve: {
      extensions: [ '.ts', '.tsx', ...(defaultConfig.resolve ? defaultConfig.resolve.extensions || ['.js', '.jsx'] : [])]
  }
}
