<?php

/**
 * 
 * 
 *
 * @link              www.scrollsequence.com
 * @since             0.7.0
 * @package           Scrollsequence
 *
 * @wordpress-plugin
 * Plugin Name: Scrollsequence (Premium)
 * Plugin URI:        https://www.scrollsequence.com
 * Description:       Create stunning image animation that play and rewind on scroll. Make your website come alive with just few clicks.  
 * Version:           2.0.0-beta.3

 * Update URI: https://api.freemius.com
 * Author:            Scrollsequence
 * Author URI:        https://www.scrollsequence.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       scrollsequence
 * Domain Path:       v1/languages
 * @fs_ignore /v1/includes/carbonfields/, /v1/public/js/gsap__premium_only.js, /v1/public/js/gsap-scrolltrigger__premium_only.js, /v2/includes/, /v2/premium/includes/  
 * @fs_premium_only /v2/build/premium/, /v2/src/premium/, /v2/premium/ 
 * 
 *   Věnování:
 *   Tento plugin je věnován mé rodině – mamince Světle,
 *   manželce Veronice, dětem Natálce a Alexovi
 *   a naší dceři Agátce, která navždy zůstane v našich srdcích.
 *
 *   Dedication:
 *   This plugin is dedicated to my family – my mother Světla,
 *   my wife Veronika, my children Natálka and Alex,
 *   and our daughter Agátka, who will forever remain in our hearts.
 * 
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( function_exists( 'freemius_scrollsequence' ) ) {
    freemius_scrollsequence()->set_basename( true, __FILE__ );
} else {
    // DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE `function_exists` CALL ABOVE TO PROPERLY WORK.
    if ( !function_exists( 'freemius_scrollsequence' ) ) {
        // ... Freemius integration snippet ...
        // FREEMIUS  COPY START
        if ( !function_exists( 'freemius_scrollsequence' ) ) {
            // Create a helper function for easy SDK access.
            function freemius_scrollsequence() {
                global $freemius_scrollsequence;
                if ( !isset( $freemius_scrollsequence ) ) {
                    // Include Freemius SDK.
                    require_once dirname( __FILE__ ) . '/includes/freemius/start.php';
                    // v1 ish
                    $freemius_scrollsequence = fs_dynamic_init( array(
                        'id'              => '5856',
                        'slug'            => 'scrollsequence',
                        'premium_slug'    => 'scrollsequence-pro',
                        'type'            => 'plugin',
                        'public_key'      => 'pk_ea24bea874c80814ebc58bc230264',
                        'is_premium'      => true,
                        'has_addons'      => false,
                        'has_paid_plans'  => true,
                        'trial'           => array(
                            'days'               => 14,
                            'is_require_payment' => false,
                        ),
                        'has_affiliation' => 'all',
                        'menu'            => array(
                            'slug'       => 'scrollsequence-dashboard',
                            'first-path' => 'admin.php?page=scrollsequence-dashboard',
                            'support'    => false,
                        ),
                        'is_live'         => true,
                    ) );
                }
                return $freemius_scrollsequence;
            }

            // Init Freemius.
            freemius_scrollsequence();
            // Signal that SDK was initiated.
            do_action( 'freemius_scrollsequence_loaded' );
        }
        // FREEMIUS COPY END
    }
    // ... Your plugin's main file logic ...
    // If this file is called directly, abort.
    if ( !defined( 'WPINC' ) ) {
        die;
    }
    // Define constants.
    define( 'SCROLLSEQUENCE_VERSION', '2.0.0-beta.3' );
    if ( !defined( 'SCROLLSEQUENCE_API_URL' ) ) {
        // can be pre-defined in wp-config.php for local development
        define( 'SCROLLSEQUENCE_API_URL', 'https://api.scrollsequence.com' );
    }
    // Plan title helper function (used in v1 and v2 dashboards)
    function scrollsequence_get_plan_title() {
        if ( freemius_scrollsequence()->is__premium_only() ) {
            // strip from free plan, so that free version shows "Free" always
            if ( freemius_scrollsequence()->is_trial() ) {
                // assume this is always correct
                $maybe_trial_plan = freemius_scrollsequence()->get_trial_plan();
                // returns false if not opted-in properly
                if ( $maybe_trial_plan && is_object( $maybe_trial_plan ) ) {
                    return esc_html( $maybe_trial_plan->title ) . ' Trial<span class="ssqplan-trial-title-1" />';
                } else {
                    return 'Trial<span class="ssqplan-trial-fallback-2" />';
                    // Fallback: assume Free if no valid object is available
                }
            } else {
                $maybe_plan = freemius_scrollsequence()->get_plan();
                // returns false if not opted-in properly
                if ( $maybe_plan && is_object( $maybe_plan ) ) {
                    return esc_html( $maybe_plan->title ) . '<span class="ssqplan-title-3"/>';
                } else {
                    return 'Free' . '<span class="ssqplan-fallback-4"/>';
                    // Fallback: assume Free if no valid object is available
                }
            }
        } else {
            return 'Free<span class="ssqplan-free-5" />';
            // free version always shows Free, even though it has a plan or plan trial activated.
        }
    }

    // Initialize the plugin.
    $scrollsequence_active_version = get_option( 'scrollsequence_active_version', 'v1' );
    // load switch render ui function
    require_once __DIR__ . '/switch.php';
    if ( $scrollsequence_active_version === 'v2' ) {
        require_once __DIR__ . '/v2/scrollsequence-v2.php';
    } else {
        require_once __DIR__ . '/v1/scrollsequence-v1.php';
    }
    // In scrollsequence.php (main file)
    function scrollsequence_maybe_flush_rewrites() {
        if ( get_transient( 'scrollsequence_flush_rewrite_rules' ) ) {
            flush_rewrite_rules();
            delete_transient( 'scrollsequence_flush_rewrite_rules' );
        }
    }

    add_action( 'init', 'scrollsequence_maybe_flush_rewrites' );
}