
<style>
/* Tooltip container */
.ssqtooltip {
  position: relative;
  display: inline-block;
  color:gray;
}

/* Tooltip text */
.ssqtooltip .ssqtooltiptext {
  visibility: hidden;
  width: 360px;
  background-color: #535151;
  color: #fff;
  text-align: center;
  padding: 10px;
  border-radius: 6px;

  position:absolute;
  top: -5px;
  left: 105%;
}

/* Show the tooltip text when you mouse over the tooltip container */
.ssqtooltip:hover .ssqtooltiptext {
  visibility: visible;
}


.ssqconvert-drag-drop-area {
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
  border: 2px dashed #ccc;
  border-radius: 5px;
  padding: 20px;
  text-align: center;
  font-size: 16px;
  color: #666;
  cursor: pointer;
  max-width:350px;
  min-height:150px;
}

.ssqconvert-drag-drop-area .dashicons {
  font-size: 50px;
  margin-bottom: 50px;
}

.ssqconvert-drag-drop-area p {
  margin: 0;
  margin-bottom: 2rem;
}

.ssqconvert-drag-drop-area:hover {
  background-color: #f9f9f9;
}

.ssqconvert-drag-drop-area.active {
  border-color: #1e8cbe;
  background-color: #f1f1f1;
  color: #1e8cbe;
}

.ssqconvert-drag-drop-area.active .dashicons {
  color: #1e8cbe;
}


.ssq-add-to-wp-gallery{
    border: 3px solid transparent;
}

.ssq-wp-media-import-complete{
    border: 3px solid green;
}

</style>



<?php 

$scrollsequence_licenseid = freemius_scrollsequence()->_get_license() ? freemius_scrollsequence()->_get_license()->id : "none";
$scrollsequence_installid = freemius_scrollsequence()->get_site()->id;
$scrollsequence_year_flk = date("Y");
$scrollsequence_month_flk = date("m");
$scrollsequence_timestamp = time();

$scrollsequence_filekey = $scrollsequence_year_flk.'-'.$scrollsequence_month_flk.'/lic-'.$scrollsequence_licenseid.'-ins-'.$scrollsequence_installid.'-ts-'.$scrollsequence_timestamp;

?>



<h3>
    <?php _e( 'Video to Image Sequence Convertor', 'scrollsequence' ); ?>
    <div class="ssqtooltip">
        <span class="dashicons  dashicons-editor-help"></span>
        <span class="ssqtooltiptext">
            <?php _e( 'Upload video and the tool will convert it to sequence of images and allow you to preview the Scrollsequence. Once you are happy, you can download the .zip file and add the media to WordPress gallery.', 'scrollsequence' ); ?>
            <br/>
        </span>
    </div>
</h3>

<section>
    <div class="ssqconvert-drag-drop-area" style="margin-left:1rem;">
        <div class="dashicons dashicons-upload"></div>
        <p>
            <?php _e( 'Drag and drop your video file here or click on "Choose File" button.', 'scrollsequence' ); ?>
        </p>
        <input 
            type="file" 
            id="ssqconvert-video-file" 
            accept="video/*" 
            style="padding-left:1rem; padding-right:2rem;"
        />
        <div id="ssqconvert-file-alert-div" style="min-height:2rem; padding-top:1.25rem;"></div>
    </div>
    <p style="margin-left:2rem;" ><i> <span  class="dashicons dashicons-database"></span> 1GB <span style="margin-left:2rem;" class="dashicons dashicons-images-alt"></span> 2000  </i></p>
    
    <div style="padding-top:2rem;">
        <label for="ssqconvert-slugname" style="display:block; font-weight:bold; margin-bottom:0.5rem;">File prefix
            <div class="ssqtooltip">
                <span class="dashicons  dashicons-editor-help"></span>
                <span class="ssqtooltiptext">
                    <?php _e( 'Only charactes &quot;a-z&quot;, &quot;0-9&quot; and hyphen &quot;-&quot; are allowed!', 'scrollsequence' ); ?>
                </span>
            </div>
        </label>
        <input 
            id="ssqconvert-slugname" 
            type="text" 
            maxlength="30" 
            onkeydown="return /[a-z0-9-]/i.test(event.key)" value="my-scrollsequence" 
            style="margin-left:1rem;"
        ></input>

    </div>

    <div style="padding-top:2rem">
        <label style="display:block; font-weight:bold;margin-bottom:0.5rem;"> 
            <?php _e( 'Quality', 'scrollsequence' ); ?> 
            <div class="ssqtooltip">
                <span class="dashicons  dashicons-editor-help"></span>
                <span class="ssqtooltiptext">
                    <?php _e( 'Choose between Aggressive compression for small file size, optimal or no compression if you want to use your own tools to bring the file size down.', 'scrollsequence' ); ?> 
                </span>
            </div>
        </label>
        
        <input type="radio" id="ssqconvert-quality-radio-aggresive" name="ssqconvert_quality_radio" value="aggressive" style="margin-left:1rem;">
        <label for="ssqconvert-quality-radio-aggresive">
            <?php _e( 'Aggressive compression (lossy)', 'scrollsequence' ); ?> 
        </label><br>

        <input type="radio" id="ssqconvert-quality-radio-optimal" name="ssqconvert_quality_radio" value="optimal" checked style="margin-left:1rem;">
        <label for="ssqconvert-quality-radio-optimal" >
            <?php _e( 'Optimal compression (recommended)', 'scrollsequence' ); ?> 
        </label><br>

        <input type="radio" id="ssqconvert-quality-radio-original" name="ssqconvert_quality_radio" value="original" style="margin-left:1rem;">
        <label for="ssqconvert-quality-radio-original">
            <?php _e( 'Original (no compression)', 'scrollsequence' ); ?> 
        </label>
        <br/>
    </div>

    <div style="padding-top:2rem">
        <label style="display:block; font-weight:bold; margin-bottom:0.5rem;">
            <?php _e( 'Maximum Resolution', 'scrollsequence' ); ?> 
            <div class="ssqtooltip">
                <span class="dashicons  dashicons-editor-help"></span>
                <span class="ssqtooltiptext">
                    <?php _e( 'Choose if you want to downscale a large resolution video to a reasonable resolution. We recommend using images no larger than 1920px for Scrollsequence.', 'scrollsequence' ); ?> 
                </span>
            </div>
        </label>
        
        <input type="radio" id="ssqconvert-downscale-radio-true" name="ssqconvert_downscale_radio" value="true" checked style="margin-left:1rem;">
        <label for="ssqconvert-downscale-radio-true">
            <?php _e( 'Downsize to fit inside 1920x1080px rectangle (recommended)', 'scrollsequence' ); ?> 
        </label><br>

        <input type="radio" id="ssqconvert-downscale-radio-false" name="ssqconvert_downscale_radio" value="false" style="margin-left:1rem;" >
        <label for="ssqconvert-downscale-radio-false" >
            <?php _e( 'No resize', 'scrollsequence' ); ?> 
        </label><br>

        <br/>
    </div>    



    <div style="padding-top:2rem;  margin-left:1rem">
        <button id="ssqconvert-submit" class="button button-primary" disabled  style="font-size:14px; line-height:unset!important;" >
            <span class="dashicons dashicons-cloud-upload"></span>
            <?php _e( 'Upload & Convert Video', 'scrollsequence' ); ?>
        </button>
    </div>



    <?php /* RESULTS 1 - PROGRESS */?>
    <div id="ssqconvert-r1-wrap" style="visibility:hidden;" >
        <h3> <?php _e( 'Job Status', 'scrollsequence' ); ?>  </h3>
        <label for="ssqconvert-r1-progress-bar" style="margin-right: 10px; margin-left:1rem">
            <?php _e( 'Upload Progress', 'scrollsequence' ); ?>: 
        </label>
        <progress id="ssqconvert-r1-progress-bar" value="0" max="100"></progress>
        <p id="ssqconvert-r1-processing-message" style="margin-bottom:1rem;  margin-left:1rem">
        </p>
    </div>
    <?php /* RESULTS 2 - OUTPUT */?>
    <div id="ssqconvert-r2-wrap" style="visibility:hidden; min-height:200px" >
        <h3> <?php _e( 'Output', 'scrollsequence' ); ?>  </h3>
        <p style="margin-left:1rem">
            <?php _e( 'All Images', 'scrollsequence' ); ?> (max 2000 <span class="dashicons dashicons-images-alt" style="font-size:14px; line-height:unset!important;"></span> )
        </p>
        <div  style="display:block; margin-left:1rem">
            <a href id="ssqconvert-r2-download-all-images" style="margin-bottom:1rem; margin-right:2rem;" class="button button-primary" >
                <?php _e( 'Download all files', 'scrollsequence' ); ?>
                <span class="dashicons dashicons-images-alt" style="font-size:14px; line-height:unset!important;"></span>
                <span class="ssqconvert-fullcount">0</span>
            </a>
        </div>
        <p style="margin-left:1rem" >
            <?php _e( 'Preview Images', 'scrollsequence' ); ?>  (max 500 <span class="dashicons dashicons-images-alt" style="font-size:14px; line-height:unset!important;"></span> )
        </p>
        <div id="ssqconvert-r2-images" style="display:block; height:400px; overflow-y: scroll; border: 1px solid #c3c4c7; padding:1rem;margin-bottom:2rem; margin-left:1rem"></div>

        <a href id="ssqconvert-r2-button-preview-images" style="margin-bottom:1rem; margin-right:2rem;  margin-left:1rem" class="button " target="_blank" >
            <?php _e( 'Preview Scrollsequence', 'scrollsequence' ); ?>
            <span class="dashicons dashicons-images-alt" style="font-size:14px; line-height:unset!important;"></span>
            <span class="ssqconvert-previewcount">0</span>
        </a>
        <button id="ssqconvert-r2-button-add-to-wp-media-gallery" style="margin-bottom:1rem;  margin-left:1rem" class="button " >
            <?php _e( 'Import to WP Media Gallery', 'scrollsequence' ); ?>
            <span class="dashicons dashicons-images-alt" style="font-size:14px; line-height:unset!important;"></span>
            <span class="ssqconvert-previewcount">0</span>
        </button>
    </div>

    <?php /* RESULTS 3 - ADD TO WP MEDIA GALLERY */?>
    <div id="ssqconvert-r3-wrap" style="visibility:hidden; min-height:200px" >
        <label for="ssqconvert-wp-media-upload-progress" style="margin-right: 10px;  margin-left:1rem">
            <?php _e( 'Importing to WP Media Gallery', 'scrollsequence' ); ?>: 
        </label>
        <progress id="ssqconvert-wp-media-upload-progress" value="0" max="100"></progress>
        <p id="ssqconvert-wp-media-upload-status" style=" margin-bottom:4rem;  margin-left:1rem" >Starting Import</p>

        <button id="add_media_to_scrollsequence" class="button button-primary">Save as Scrollsequence</button>
        <br/><br/>
        <div id="add_media_to_scrollsequence_result"></div>
    </div>



    <?php 
    /*
        Tooltip:                <span class="dashicons dashicons-editor-help"></span>
        Images:                 <span style="margin-left:2rem;" class="dashicons dashicons-images-alt"></span>
        WP Media Gallery:       <span class="dashicons dashicons-admin-media"></span>
        Preview:                <span class="dashicons dashicons-welcome-view-site"></span>
        Zip (archive)           <span class="dashicons dashicons-media-archive"></span>
        Store: (buy)            <span class="dashicons dashicons-store"></span>
    */
     ?>




</section>

<?php if (freemius_scrollsequence()->is_plan_or_trial__premium_only('BUSINESS', true)) { ?>

    <script>
    (function () {
        // Define vars
        let DBG=true;
        const dragDropArea = document.querySelector('.ssqconvert-drag-drop-area');
        const videoFileInput = document.querySelector('#ssqconvert-video-file');
        const fileAlertDiv = document.querySelector('#ssqconvert-file-alert-div');
        let videoFileVar = null

        let slugnameInput = document.querySelector('#ssqconvert-slugname');

        const qualityRadioAggressive = document.querySelector('#ssqconvert-quality-radio-aggresive');
        const qualityRadioOptimal = document.querySelector('#ssqconvert-quality-radio-optimal');
        const qualityRadioOriginal = document.querySelector('#ssqconvert-quality-radio-original');

        const downscaleRadioTrue = document.querySelector('#ssqconvert-downscale-radio-true');
        const downscaleRadioFalse = document.querySelector('#ssqconvert-downscale-radio-false');

        const submit = document.querySelector('#ssqconvert-submit');

        // RESULTS 1 - PROGRESS
        const r1Wrap = document.querySelector('#ssqconvert-r1-wrap');
        const r1Progress = document.querySelector('#ssqconvert-r1-progress-bar');
        const r1Message = document.querySelector('#ssqconvert-r1-processing-message');

        // RESULTS 2 - OUTPUT
        const r2Wrap = document.querySelector('#ssqconvert-r2-wrap');
        const r2DownloadAllImages = document.querySelector('#ssqconvert-r2-download-all-images');
        const r2Images = document.querySelector('#ssqconvert-r2-images');
        const r2ButtonPreviewImages = document.querySelector('#ssqconvert-r2-button-preview-images');
        const r2ButttonAddToWpMedia = document.querySelector('#ssqconvert-r2-button-add-to-wp-media-gallery');

        // RESULTS 3 - ADD TO WP MEDIA GALLERY 
        const r3Wrap = document.querySelector('#ssqconvert-r3-wrap');
        const r3Progress = document.querySelector('#ssqconvert-wp-media-upload-progress');
        const r3Status = document.querySelector('#ssqconvert-wp-media-upload-status');

        let r3IdsAdded = []; // store ids of images added to WP Media Gallery


        let jsonUrl = null
        let jsonUrlData = null 
        let waitingTime = 0;

        // DRAG AND DROP AREA 
        dragDropArea.addEventListener('dragover', (event) => {
            event.preventDefault();
            dragDropArea.classList.add('active');
        });
        dragDropArea.addEventListener('dragleave', () => {
            dragDropArea.classList.remove('active');
        });
        dragDropArea.addEventListener('drop', (event) => {
            event.preventDefault();
            if (videoFileInput.disabled === !true){
                dragDropArea.classList.remove('active');
                videoFileVar = event.dataTransfer.files[0];
                DBG&&console.log('drop!',videoFileVar);
                checkFileInput(videoFileVar)
            }
        });
        // FILE INPUT AREA
        videoFileInput.addEventListener('change', () => {
            videoFileVar = videoFileInput.files[0];
            DBG&&console.log('change!', videoFileVar);
            checkFileInput(videoFileVar)
        });
        // CHECK FILE INPUT 
        function checkFileInput(videoFileVar){
            DBG&&console.log('checkFileInput() videoFileVar:',videoFileVar)
            
            if (videoFileVar.size > 1000000 * 1000) { // Check size 
                alert('Error: File size too large')
                fileAlertDiv.innerHTML = 'Error, File size too large';
                fileAlertDiv.style.color = "red"
                submit.disabled=true;
            } else if ( videoFileVar.type.includes("video") ){
                fileAlertDiv.innerHTML = 'File Accepted';
                fileAlertDiv.style.color = "green"
                submit.disabled=false;
            } else {
                alert('Error: Please select a video file')
                fileAlertDiv.innerHTML = 'Error: Please select a video file';
                fileAlertDiv.style.color = "red"
                submit.disabled=true;
            }
        }

        // FORM SUBMIT
        submit.addEventListener('click', ()=> { ssqConvertHandleFormSubmit() } ); 
        async function ssqConvertHandleFormSubmit(){
            DBG&&console.log('ssqConvertHandleFormSubmit')
            // STATE 
            videoFileInput.disabled=true;
            slugnameInput.disabled=true;

            qualityRadioAggressive.disabled=true;
            qualityRadioOptimal.disabled=true;
            qualityRadioOriginal.disabled=true;

            downscaleRadioTrue.disabled=true;
            downscaleRadioFalse.disabled=true;

            submit.disabled=true;


            r1Wrap.style.visibility="visible";

            // 1 GET PRESIGNED URL
            const response = await fetch(
                '<?php echo $SCROLLSEQUENCEAPIROOT; ?>/media-convert-upload/',
                {
                    method: 'POST',
                    headers: {
                    'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ 
                        // VERY IMPORTANT, VERY HARD TO CHANGE AFTER RELEASE OF SSQ 1.5.0
                        version: "<?php echo SCROLLSEQUENCE_VERSION; ?>",
                        licenseid: "<?php echo $scrollsequence_licenseid; ?>",
                        installid: "<?php echo $scrollsequence_installid; ?>",
                        filekey: '<?php echo $scrollsequence_filekey; ?>', 
                        originalfilename: videoFileVar.name,
                        originalfileext: videoFileVar.name.substr(videoFileVar.name.lastIndexOf('.')+1,videoFileVar.name.length),
                        slugname: slugnameInput.value,
                        quality: document.querySelector('input[name="ssqconvert_quality_radio"]:checked').value,
                        downscale: document.querySelector('input[name="ssqconvert_downscale_radio"]:checked').value,
                    }),
                }
            )      

            if (response.ok) {
                DBG&&console.log('response.ok')
                const responseJson = await response.json()

                if (responseJson.error){
                    alert(responseJson.error) // this is my custom error message from plugin
                    return;
                } else {
                    // REQUEST TO S3
                    var xhr = new XMLHttpRequest();
                    xhr.onreadystatechange = function() {
                    if (xhr.readyState === 4) {
                        if (xhr.status === 200) {
                            //alert('Upload successful!')
                            r1Progress.style.accentColor="gray"

                            jsonUrl = `https://scrollsequence-media-convert-v1-out.s3.eu-west-1.amazonaws.com/v1-<?php echo $scrollsequence_filekey; ?>/out.json`;
                            checkUrl()
                        }
                        else {
                            console.error('S3 Upload Error:', uploadResponse)
                            alert('Upload failed.')
                            r1Progress.style.accentColor="red"
                            submit.disabled=false;
                        }
                    }
                    };
                    xhr.upload.onprogress = function(e) {
                        if (e.lengthComputable) {
                            var percentComplete = (e.loaded / videoFileVar.size) * 100;
                            //console.log('percentComplete:',percentComplete)
                            r1Progress.value=percentComplete
                            r1Progress.innerHTML=percentComplete+"%"
                        }
                    };
                    xhr.open("PUT", responseJson.url);
                    xhr.send(videoFileVar);
                }
            } else {
                DBG&&console.log('response NOT OK')
                alert('ERROR: Failed to get pre-signed URL.')
            } 
        }
        
        // THIS GIVES CONSOLE LOG ERROR, WANT TO AVOID THAT WITH TRY/CATCH
        async function checkUrl(){
            const jsonStat = await fetch (jsonUrl)

            console.log('x',jsonStat)
            if (jsonStat.ok != true ){
                setTimeout(() => {
                    console.log("A: Delayed for 1 second. ");
                    if (waitingTime > 180){
                        r1Message.innerHTML="Timeout Error: Try shorter video.";
                    } else {
                        r1Message.innerHTML="Processing video ("+waitingTime+"s )";
                    }
                    
                    waitingTime=waitingTime+1
                    checkUrl()
                }, 1000);
            } else {
                jsonUrlData = await jsonStat.json()
                console.log('jsonStat success :jsonUrlData',jsonUrlData )
                r1Message.innerHTML="Video Processing Complete";
                showResults()
            }
        }
        


        let previewImgLength = 0;
        let allImgLength = 0;

        function showResults(){
            console.log('showResults()')
            r2Wrap.style.visibility="visible";
            // show results 1 ()
            previewImgLength = jsonUrlData.previewLength
            allImgLength = jsonUrlData.length
            setImgLengthValues("ssqconvert-previewcount", previewImgLength)
            setImgLengthValues("ssqconvert-fullcount", allImgLength)


            // show results 2 (url list?)
            for (let i = 0; i < previewImgLength; i++) {
                let img = new Image();
                img.style.marginRight="0.5rem";
                img.classList.add("ssq-add-to-wp-gallery");
                img.width=100;
                img.src =   `https://scrollsequence-media-convert-v1-out.s3.eu-west-1.amazonaws.com/v1-<?php echo $scrollsequence_filekey; ?>/i/${slugnameInput.value}-${pad(i, 4)}.jpg`;
                r2Images.appendChild(img);
            }
            r2DownloadAllImages.href=`https://scrollsequence-media-convert-v1-out.s3.eu-west-1.amazonaws.com/v1-<?php echo $scrollsequence_filekey; ?>/${slugnameInput.value}-${document.querySelector('input[name="ssqconvert_quality_radio"]:checked').value}-out.zip`
            r2ButtonPreviewImages.href =  `<?php echo admin_url() ?>admin.php?page=scrollsequence-preview&length=${previewImgLength}&root=${encodeURIComponent("https://scrollsequence-media-convert-v1-out.s3.eu-west-1.amazonaws.com/v1-<?php echo $scrollsequence_filekey; ?>/i/"+slugnameInput.value)}`
        }


        r2ButttonAddToWpMedia.addEventListener('click', (event) => {
            event.preventDefault();
            // Display a confirmation dialog with the message "O rly?"
            const userConfirmed = confirm(`Do you want to add the ${previewImgLength} images to WordPress Media Gallery?`);

            // Check if the user clicked "OK"
            if (userConfirmed) {
                addToWPMediaGallery()
            } else {
                console.log("User canceled!");
            }            
        });

        async function addToWPMediaGallery(){
            r3IdsAdded = [] // reset ids
            const images = document.querySelectorAll('.ssq-add-to-wp-gallery');
            const totalImages = images.length;

            r2ButttonAddToWpMedia.disabled=true;
            r3Wrap.style.visibility="visible";

            for (let i = 0; i < totalImages; i++) {
                const imageUrl = images[i].src;
                const imageResponse = await fetch(imageUrl);
                const imageBlob = await imageResponse.blob();

                const formData = new FormData();
                formData.append('file', imageBlob, imageUrl.split('/').pop());
                formData.append('_wpnonce', "<?php echo wp_create_nonce('wp_rest'); ?>"); 

                try {
                    const response = await fetch("<?php echo esc_url_raw(rest_url()); ?>wp/v2/media", { 
                        method: 'POST',
                        body: formData,
                        headers: {
                            'Accept': 'application/json',
                        },
                    });

                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }

                    const data = await response.json();
                    console.log('Upload successful!', data);
                    r3IdsAdded.push(data.id);

                    images[i].classList.add("ssq-wp-media-import-complete");

                    // Update the progress element
                    r3Progress.value = ((i + 1) / totalImages) * 100;

                    // Update the status element
                    r3Status.textContent = `Imported ${i + 1} of ${totalImages} images.`;
                    // Import Complete
                    if (i+1 === totalImages){
                        r3Status.textContent = `All ${i + 1} images successfully imported to WP Media Gallery.`;
                    }

                } catch (error) {
                    alert('There was a problem with adding media to WordPress gallery. Try saving the .zip file and uploading manually. You can find more information in the console log.')
                    console.error('There was a problem with the upload.', error);

                    // Update the status element with the error
                    r3Status.textContent = `Error: ${error.message}`;

                    return;
                }
            }            
        }

        function setImgLengthValues(className, value, ) {
            const elements = document.querySelectorAll(`.${className}`);
            elements.forEach((element) => {
                element.innerHTML = value;
            });
        }
        function pad(num, size) {
            let s = num + "";
            while (s.length < size) s = "0" + s;
            return s;
        }


        document.getElementById('add_media_to_scrollsequence').addEventListener('click', function() {

            const data = {
                title: 'Convertor: '+slugnameInput.value,  //"Custom ScrollSequence",
                media_ids: r3IdsAdded,
                //start_trigger: 0.7 // Example: changing the start_trigger value
            };

            console.log('data',data)

            fetch(ajaxurl, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    action: 'add_scrollsequence_post',
                    data: JSON.stringify(data) // Send as a JSON string
                })
            })
            .then(response => response.json())
            .then(data => {
                document.getElementById('add_media_to_scrollsequence_result').innerText = data.message;
                //document.getElementById('add_media_to_scrollsequence').disabled = true;
            }) 
            .catch(error => console.error('Error adding media to WP:', error));

        });


    })();
    </script>
<?php } else { ?>
    <script>
        (function () {
            const submitButton = document.querySelector('#ssqconvert-submit');
            submitButton.disabled=false; 

            submitButton.addEventListener('click', ()=> { ssqConvertHandleFormSubmit() } ); 
            function ssqConvertHandleFormSubmit(){
                if (confirm("Video Convert is available on Business plans only. Do you wish to continue?")) {
                    window.location.href = "<?php echo admin_url( 'admin.php?page=scrollsequence-dashboard-pricing&trial=true' ) ?>";
                }
            }
        })();
    </script>
<?php } ?>

