<?php 

function scroll_sequence_register_my_cpt_scroll_sequence() {

    /**
     * Post Type: Scrollsequences.
     *  This is the post type that serves the "main" purpose. 
     *  (syntax from ACF plugin)
     */

    $labels = [
        "name" => esc_html__( "Scrollsequences","scrollsequence" ),
        "singular_name" => esc_html__( "Scrollsequence","scrollsequence" ),
        "menu_name" => esc_html__( "Scrollsequence","scrollsequence" ),
        "all_items" => esc_html__( "All Scrollsequences","scrollsequence" ),
        "add_new" => esc_html__( "Add new","scrollsequence" ),
        "add_new_item" => esc_html__( "Add new Scrollsequence","scrollsequence" ),
        "edit_item" => esc_html__( "Edit Scrollsequence","scrollsequence" ),
        "new_item" => esc_html__( "New Scrollsequence","scrollsequence" ),
        "view_item" => esc_html__( "View Scrollsequence","scrollsequence" ),
        "view_items" => esc_html__( "View Scrollsequences","scrollsequence" ),
        "search_items" => esc_html__( "Search Scrollsequences","scrollsequence" ),
        "not_found" => esc_html__( "No Scrollsequences found","scrollsequence" ),
        "not_found_in_trash" => esc_html__( "No Scrollsequences found in trash","scrollsequence" ),
        "parent" => esc_html__( "Parent Scrollsequence:","scrollsequence" ),
    "featured_image" => esc_html__( "Featured image for this Scrollsequence","scrollsequence" ),
        "set_featured_image" => esc_html__( "Set featured image for this Scrollsequence","scrollsequence" ),
        "remove_featured_image" => esc_html__( "Remove featured image for this Scrollsequence","scrollsequence" ),
        "use_featured_image" => esc_html__( "Use as featured image for this Scrollsequence","scrollsequence" ),
        "archives" => esc_html__( "Scrollsequence archives","scrollsequence" ),
        "insert_into_item" => esc_html__( "Insert into Scrollsequence","scrollsequence" ),
        "uploaded_to_this_item" => esc_html__( "Upload to this Scrollsequence","scrollsequence" ),
        "filter_items_list" => esc_html__( "Filter Scrollsequences list","scrollsequence" ),
        "items_list_navigation" => esc_html__( "Scrollsequences list navigation","scrollsequence" ),
        "items_list" => esc_html__( "Scrollsequences list","scrollsequence" ),
        "attributes" => esc_html__( "Scrollsequences attributes","scrollsequence" ),
        "name_admin_bar" => esc_html__( "Scrollsequence","scrollsequence" ),
        "item_published" => esc_html__( "Scrollsequence published","scrollsequence" ),
        "item_published_privately" => esc_html__( "Scrollsequence published privately.","scrollsequence" ),
        "item_reverted_to_draft" => esc_html__( "Scrollsequence reverted to draft.","scrollsequence" ),
        "item_trashed" => esc_html__( "Scrollsequence trashed.","scrollsequence" ),
        "item_scheduled" => esc_html__( "Scrollsequence scheduled","scrollsequence" ),
        "item_updated" => esc_html__( "Scrollsequence updated.","scrollsequence" ),
        "parent_item_colon" => esc_html__( "Parent Scrollsequence:","scrollsequence" ),
    ];

    $args = [
        "label" => esc_html__( "Scrollsequences","scrollsequence" ),
        "labels" => $labels,
        "description" => "",
        "public" => true,
        "publicly_queryable" => true,
        "show_ui" => true,
        "show_in_rest" => true,
        "rest_base" => "",
        "rest_controller_class" => "WP_REST_Posts_Controller",
        "rest_namespace" => "wp/v2",
        "has_archive" => false,
        //"show_in_menu" => true, //old
        'show_in_menu' => 'scrollsequence-dashboard', // new
        "show_in_nav_menus" => false,
        "delete_with_user" => false,
        "exclude_from_search" => false,
        "capability_type" => "post",
        "map_meta_cap" => true,
        "hierarchical" => false,
        "can_export" => false,
        "rewrite" => [ "slug" => "scroll-sequence", "with_front" => true ],
        "query_var" => true,
        "supports" => [ "title", "editor", "thumbnail", "custom-fields", "revisions" ],
        "show_in_graphql" => false,

    ];

    register_post_type( "scroll-sequence", $args );

    // Flush rewrite rules to avoid 404 errors after registering the CPT
    //flush_rewrite_rules();
}
add_action( 'init', 'scroll_sequence_register_my_cpt_scroll_sequence' );

/**
 * 2. Register "ssq-media" CPT and images meta
 * (syntax from GPT)
 */
add_action( "init", function () {
	register_post_type( "ssq-media", array(
		"labels" => array(
			"name"               => esc_html__( "Scrollsequence Media", "scrollsequence" ),
			"singular_name"      => esc_html__( "Scrollsequence Media", "scrollsequence" ),
			"add_new_item"       => esc_html__( "Add New Scrollsequence Media", "scrollsequence" ),
			"edit_item"          => esc_html__( "Edit Scrollsequence Media", "scrollsequence" ),
			"view_item"          => esc_html__( "View Scrollsequence Media", "scrollsequence" ),
			"search_items"       => esc_html__( "Search Scrollsequence Media", "scrollsequence" ),
		),
		"public"             => false,              // not publicly queryable on front-end
		"show_ui"            => true,               // show in wp-admin
		'show_in_menu'       => 'upload.php',       // <<-- place under Media
		"show_in_rest"       => true,               // allow editing in block editor / REST
		"supports"           => array( "title" , "custom-fields" ),   // just a title and custom-fields for now
		"capability_type"    => "post",
		"map_meta_cap"       => true,
		"menu_icon"          => "dashicons-images-alt2",
	) );
} );