<?php
/**
 * PHP file to use when rendering the block type on the server to show on the front end.
 *
 * The following variables are exposed to the file:
 *     $attributes (array): The block attributes.
 *     $content (string): The block default content.
 *     $block (WP_Block): The block instance.
 *
 * @see https://github.com/WordPress/gutenberg/blob/trunk/docs/reference-guides/block-api/block-metadata.md#render
 */

$height = isset($attributes['height']) ? $attributes['height'] : '';
$heightUnit = isset($attributes['heightUnit']) ? $attributes['heightUnit'] : '';
$heightWithUnit = $height . $heightUnit;

// Initialize extra attributes for the wrapper div
$scroll_sequence_extra_attributes = [
    'class' => 'ssq-not-hydrated',
	'style' => ($heightWithUnit ? 'height:'.$heightWithUnit.';' : '').'width:100%;',

];

?>

<div 
    <?php echo wp_kses_data( get_block_wrapper_attributes($scroll_sequence_extra_attributes) ); ?>  
    data-ssq-canvas1d='<?php echo wp_json_encode($attributes);?>' 
>
    <canvas></canvas>
</div>

