import { useState } from 'react';
declare const scroll_sequence_editor_data: any;

/*

This is intended to be a playground for testing API calls, error handling etc.


*/

const debug = false;

// Fetch study example
export default function TabDevonly(){
    const [ someData, setSomeData ] = useState(null);
    const [ someError, setSomeError ] = useState(null);

        const handleClick = async () => {
            debug&&console.log('AAA handleClick() Devonly tab button clicked');
            try {
                const response = await fetch(`${scroll_sequence_editor_data.scrollSequenceApiUrl}/soukrome/fetch-study`, {
                    method: 'GET',
                    headers: {
                        'Authorization': `${scroll_sequence_editor_data.fs_auth_hash}`,
                        'Content-Type': 'application/json',
                    },
                });
                const data = await response.json();
                debug&&console.log('BBB data:', data);

                if (!response.ok ) { // check for non 200 response
                    console.warn('CCC data error response:', data);
                    setSomeError(data);
                } else {
                    debug&&console.log('DDD data success response:', data);
                    setSomeData(data)
                }

            } catch (error: any) { // network errors etc.
                console.warn('EEE Error fetching error:', error);
                setSomeError(error.message || 'An unexpected error occurred.');
            } 
            debug&&console.log('ZZZ handleClick() Devonly tab button finished');
        };
    return(
        <div>
            <h2>Developer Only Tab</h2>
            <p>This tab is visible only in development mode.</p>
            <button onClick={handleClick}>Click</button>
            <h2>Fetched Data:</h2>
            <pre>{JSON.stringify(someData, null, 2)}</pre>
            <h2>Error:</h2>
            <pre>{JSON.stringify(someError, null, 2)}</pre>
        </div>
    )
}