import { ReactElement } from "react";
import VariablesControl from "./c3d/VariablesControl";
declare const wp: any; // typescript error without this line
declare const scroll_sequence_editor_data: any; // typescript error without this line
const { addFilter } = wp.hooks;

import { AttributesCanvas3d } from "../../v2/blocks/canvas3d/types";

/**
 * 
 * THIS FILE IS MEANT TO EXTEND THE BLOCK EDITOR VIA FILTERS
 * 
 */
//console.log('hello from extend block for scroll sequence v2 premium');
addFilter('scroll-sequence-testv2', 'scroll-sequence/v2-canvas2d', function (component:ReactElement,) {
    const plan = scroll_sequence_editor_data  ? scroll_sequence_editor_data.current_plan : null;
    return <div style={{border: "1px solid red"}}>Plan premium: (v2) <pre>{JSON.stringify(plan, null,2)}</pre></div>
})

// canvas 2d wss control 
addFilter('scrollsequence-c2d-wss-control', 'scroll-sequence', function () {
    return false; // Premium version has no wss control
});

// canvas 3d variables control
addFilter('scrollsequence-c3d-variables-control', 'scroll-sequence', function (component:ReactElement, attributes: AttributesCanvas3d, setAttributes: any, elRef: any):ReactElement {
    return (
        <VariablesControl
                attributes={attributes} 
                setAttributes={setAttributes} 
                elRef={elRef}
        />  
    )
});


// free version notice (REMOVED because it does not work outside of blocks)
// addFilter('scrollsequence-freeversion-notice', 'scroll-sequence', function (component:ReactElement,) {
//     return <></>; // return nothing if we have premium version.
// })