//@ts-ignore
import { Notice, ExternalLink } from '@wordpress/components';

import getHrefOptin from "../v2/getHrefOptin";

declare const scroll_sequence_editor_data : any

export default function TrackingNotice(){
    const trackingAllowed = Boolean(Number(scroll_sequence_editor_data.trackingAllowed)) // converts "1"/"0" to boolean

    const isFreeVersion = ['free', 'PLAN_NAME'].includes(scroll_sequence_editor_data.current_plan); // PLAN_NAME is free plan for testing

    //console.log('TrackingNotice:, scroll_sequence_editor_data.trackingAllowed:', scroll_sequence_editor_data.trackingAllowed, ' trackingAllowed:',trackingAllowed, 'isFreeVersion:',isFreeVersion);
    
    
    return (
        <>
            { isFreeVersion && !trackingAllowed &&
                <Notice status="warning" isDismissible={false} style={{marginBottom: '10px'}}>
                    <strong>Action Required:</strong> To use Scrollsequence's API, generating images, videos, blocks or animations, you need to <ExternalLink href={getHrefOptin()}>Opt In</ExternalLink> to Scrollsequence to allow us to process your requests. 
                </Notice>
            }
        </>
    )
}