//@ts-ignore
import { __ } from '@wordpress/i18n';
//@ts-ignore
import { DropdownMenu, MenuGroup, MenuItem } from '@wordpress/components';
import { plusCircleFilled, wordpress, link, positionCenter } from '@wordpress/icons';
import type { AttributesCanvas2d } from '../../../v2/blocks/canvas2d/types';

import { addMediaGroup } from '../addMediaGroup';

export default function CreateMediaGroupDropdown({
    attributes,
    setAttributes,
    index,
    setIndex,
}:{
    attributes: AttributesCanvas2d
    setAttributes: any
    index: number
    setIndex: any
}){

        

    return (
    <DropdownMenu icon={ plusCircleFilled }  label={ __( 'Create Media Group', 'scrollsequence' ) }>
        { ( { onClose }:any ) => (
            <>
                <MenuGroup>
                    <MenuItem 
                        icon={ wordpress } 
                        onClick={ ()=> {
                            addMediaGroup({type:'wpMedia', attributes, setAttributes}); 
                            setIndex(attributes.mediaGroups.length); // set the index to the last added media group
                            onClose()
                        }}
                    >
                        WP Media Images
                    </MenuItem>
                    <MenuItem 
                        icon={ link } 
                        onClick={ ()=> {
                            addMediaGroup({type:'urlList', attributes, setAttributes}); 
                            setIndex(attributes.mediaGroups.length); // set the index to the last added media group
                            onClose()
                        }}
                    >
                        URL Image List
                    </MenuItem>
                </MenuGroup>
                <MenuGroup>
                    <MenuItem 
                        icon={ wordpress } 
                        onClick={ ()=> {
                            addMediaGroup({type:'wpVideo', attributes, setAttributes}); 
                            setIndex(attributes.mediaGroups.length); // set the index to the last added media group
                            onClose()
                        }}
                    >
                        WP Media Video
                    </MenuItem>
                    <MenuItem 
                        icon={ link } 
                        onClick={ ()=> {
                            addMediaGroup({type:'urlVideo', attributes, setAttributes}); 
                            setIndex(attributes.mediaGroups.length); // set the index to the last added media group
                            onClose()
                        }}
                    >
                        Video URL
                    </MenuItem>
                </MenuGroup>                
                <MenuGroup>
                    <MenuItem 
                        icon={ positionCenter } 
                        onClick={ ()=> {
                            addMediaGroup({type:'gap', attributes, setAttributes}); 
                            onClose()
                        }}
                    >
                        Gap
                    </MenuItem>
                </MenuGroup>
            </>
        ) }
    </DropdownMenu>
    )
};