//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import {  __experimentalNumberControl as NumberControl,  } from '@wordpress/components';
import { AttributesCanvas2d } from '../../../v2/blocks/canvas2d/types';
export default function DurationNumberControl({
    label, attributes, setAttributes, index
}:{
    label:string,
    attributes:AttributesCanvas2d, 
    setAttributes:any, 
    index:number
}){
    return(
        <NumberControl
            __next40pxDefaultSize
            label={label}
            isShiftStepEnabled={ true }
            onChange={ (value:any)=>{
                const newMediaGroups = [...attributes.mediaGroups]
                newMediaGroups[index].duration= Number(value)
                setAttributes({mediaGroups: newMediaGroups})
            }}
            min={1}
            max={1000}
            shiftStep={ 10 }
            value={ attributes.mediaGroups[index].duration }
        />    
    )
}
