//@ts-ignore
import { __ } from '@wordpress/i18n';

import { 
    Button, 
    DropdownMenu, 
    Icon,
    __experimentalConfirmDialog as ConfirmDialog
    //@ts-ignore
} from '@wordpress/components';
import type { MediaGroups } from '../types';
import Stack from '@mui/material/Stack';
import { useState } from 'react';
import { arrowLeft, arrowRight, ungroup, trash, moreVertical } from '@wordpress/icons';

import type { AttributesCanvas2d } from '../../../v2/blocks/canvas2d/types';

//import MoveUpIcon from '@mui/icons-material/MoveUp';
//import MoveDownIcon from '@mui/icons-material/MoveDown';

const MoveUpIcon = (props: React.SVGProps<SVGSVGElement>) => (
	<svg 
	  xmlns="http://www.w3.org/2000/svg" 
	  viewBox="0 0 24 24" 
      width="24"
      height="24"
      {...props}
	>
        <path d="M3 13c0-2.45 1.76-4.47 4.08-4.91l-1.49 1.5L7 11l4-4.01L7 3 5.59 4.41l1.58 1.58v.06C3.7 6.46 1 9.42 1 13c0 3.87 3.13 7 7 7h3v-2H8c-2.76 0-5-2.24-5-5m10 0v7h9v-7zm7 5h-5v-3h5zM13 4h9v7h-9z"></path>
	</svg>
);
const MoveDownIcon = (props: React.SVGProps<SVGSVGElement>) => (
	<svg 
	  xmlns="http://www.w3.org/2000/svg" 
	  viewBox="0 0 24 24" 
      width="24"
      height="24"
      {...props}
	>
        <path d="M3 11c0 2.45 1.76 4.47 4.08 4.91l-1.49-1.49L7 13l4 4.01L7 21l-1.41-1.41 1.58-1.58v-.06C3.7 17.54 1 14.58 1 11c0-3.87 3.13-7 7-7h3v2H8c-2.76 0-5 2.24-5 5m19 0V4h-9v7zm-2-2h-5V6h5zm-7 4h9v7h-9z"></path>
	</svg>
);

export default function MediaGroupActions({
    uiVariant = 'default',
    attributes,
    setAttributes,
    index,
    setIndex
}: {
    uiVariant?: 'default' | 'dropdown',
    attributes: AttributesCanvas2d,
    setAttributes: any
    index: number
    setIndex: any
}) {
    const [isDialogOpen, setIsDialogOpen] = useState(false);

    // HANDLE MOVE LEFT CLICK
    function handleMoveLeftClick() {
        console.log('MediaGroupActions () handleMoveLeftClick', index);
        const newMediaGroups = [...attributes.mediaGroups];
        const mediaGroupToMove = attributes.mediaGroups[index];
        newMediaGroups.splice(index - 1, 0, mediaGroupToMove);
        newMediaGroups.splice(index + 1, 1);
        setAttributes({ mediaGroups: newMediaGroups });
        setIndex(index - 1); // Move to the left group
    }

    // HANDLE MOVE RIGHT CLICK
    function handleMoveClickRight() {
        console.log('MediaGroupActions () handleMoveClickRight', index);
        const newMediaGroups = [...attributes.mediaGroups];
        const [mediaGroupToMove] = newMediaGroups.splice(index, 1); // Remove the group first
        newMediaGroups.splice(index + 1, 0, mediaGroupToMove); // Insert at the new position
        setAttributes({ mediaGroups: newMediaGroups });
        setIndex(index + 1); // Move to the right group
    }

    // DUPLICATE MEDIA GROUP
    function handleDuplicateGroupClick() {
        console.log('MediaGroupActions () handleDuplicateGroupClick', index);
        const newMediaGroups = [...attributes.mediaGroups];
        const mediaGroupToDuplicate = attributes.mediaGroups[index];
        newMediaGroups.splice(index + 1, 0, { ...mediaGroupToDuplicate });
        setAttributes({ mediaGroups: newMediaGroups });
        setIndex(index + 1); // Move to the duplicated group
    }

    // DELETE MEDIA GROUP (with confirmation)
    function handleRemoveGroupClick() {
        setIsDialogOpen(true); // Open the dialog
    }
    function handleConfirmDelete() {
        console.log('MediaGroupActions () handleConfirmDelete', index);
        const newMediaGroups = [...attributes.mediaGroups].filter((_, i) => i !== index);
        setAttributes({ mediaGroups: newMediaGroups });
        setIndex(0); // Reset to the first tab
        setIsDialogOpen(false); // Close the dialog
    }
    function handleCancelDelete() {
        setIsDialogOpen(false); // Close the dialog
    }


    console.log('uiVariant', uiVariant,);
    if (uiVariant === 'dropdown') {
        return (
        <>
            <DropdownMenu
                icon={ moreVertical }
                label="Select Action"
                controls={ [
                    {
                        title: __('Move Left', 'scrollsequence'),
                        icon: 
                            <Icon 
                                icon={<MoveUpIcon style={{ transform: "rotate(270deg)", transformOrigin: "center" }} />}  
                            />,
                        onClick: () => handleMoveLeftClick(),
                        isDisabled: index === 0,
                    },
                    {
                        title: __('Move Right', 'scrollsequence'),
                        icon: 
                            <Icon 
                                icon={<MoveDownIcon style={{ transform: "rotate(270deg)", transformOrigin: "center" }} />}  
                            />,
                        onClick: () => handleMoveClickRight(),
                        isDisabled: index === attributes.mediaGroups.length - 1,
                    },
                    {
                        title: __('Duplicate', 'scrollsequence'),
                        icon: <Icon icon={ungroup} /> ,
                        onClick: () => handleDuplicateGroupClick()
                    },
                    {
                        title: __('Delete', 'scrollsequence'),
                        icon: <Icon icon={trash} isDestructive />,
                        onClick: () => {
                            handleRemoveGroupClick()
                        },

                    }
                ] }
            />   
            <ConfirmDialog
                title={__('Delete Media Group', 'scrollsequence')}
                onConfirm={handleConfirmDelete}
                onCancel={handleCancelDelete}
                isOpen={isDialogOpen}
            >
                {__('Are you sure you want to delete this media group?', 'scrollsequence')}
            </ConfirmDialog>
        </> 
        )
    
    }

    // UI variant default 
    return (
        <>
            <Stack 
                direction="row" 
                spacing={2} 
                //sx={{ padding: 1, marginLeft: 2 }}
            >
                <Button
                    size="small"
                    onClick={handleMoveLeftClick}
                    disabled={index === 0}
                    icon={<MoveUpIcon style={{ transform: "rotate(270deg)", transformOrigin: "center" }} />}
                    label={__('Move Left', 'scrollsequence')}
                />
                <Button
                    size="small"
                    onClick={handleRemoveGroupClick}
                    icon={trash}
                    isDestructive
                    label={__('Delete', 'scrollsequence')}
                />
                <Button
                    size="small"
                    onClick={handleDuplicateGroupClick}
                    icon={ungroup}
                    label={__('Duplicate', 'scrollsequence')}
                />
                <Button
                    size="small"
                    onClick={handleMoveClickRight}
                    disabled={index === attributes.mediaGroups.length - 1}
                    icon={<MoveDownIcon style={{ transform: "rotate(270deg)", transformOrigin: "center" }} />}
                    label={__('Move Right', 'scrollsequence')}
                />
            </Stack>

            <ConfirmDialog
                title={__('Delete Media Group', 'scrollsequence')}
                onConfirm={handleConfirmDelete}
                onCancel={handleCancelDelete}
                isOpen={isDialogOpen}
            >
                {__('Are you sure you want to delete this media group?', 'scrollsequence')}
            </ConfirmDialog>
        </>
    );
}