/**
 * 
 * This is the root file for the media manager full width component.
 * 
 * It is used in two places:    
 *  - wp-admin screen for media custom post type
 *  - gutenberg editor for the block attributes
 * 
 */
//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Button, Icon } from '@wordpress/components';
import { useState } from '@wordpress/element';

import { styled } from '@mui/material/styles';
import Stack from '@mui/material/Stack';
import Tabs from '@mui/material/Tabs';
import Tab from '@mui/material/Tab';
import Box from '@mui/material/Box';

import TabStyled from '../components/TabStyled'
import TabPanel from '../components/TabPanel'
import IconImageGroups from '../components/IconImageGroups'
import CreateMediaGroupDropdown from '../components/CreateMediaGroupDropdown';

import { MediaGroups } from "../types";
import { mediaGroupSchema } from "../typesZod";
import { trash, code } from '@wordpress/icons';
import { AttributesCanvas2d } from '../../../v2/blocks/canvas2d/types';


export default function MediaManagerFullWidth({
    attributes, 
    setAttributes,
    index,
    setIndex,
}:{
    attributes: AttributesCanvas2d; 
    setAttributes: any;
    index: number;
    setIndex: any;
}){

    const [ localMediaGroups, setLocalMediaGroups ] = useState(attributes.mediaGroups);

    // TABS
    function a11yProps(index: number | 'all') {
        return {
            id: `vertical-tab-${index}`,
            'aria-controls': `vertical-tabpanel-${index}`,
        };
    }    
    const handleTabChange = (event: React.SyntheticEvent, newValue: number | 'all') => {
        setIndex(newValue);
    };    
   
    return (
        <>
            <Stack direction="row" justifyContent={"start"} sx={{borderBottom: "1px solid #ccc", mx: "-16px" }}>
                <Tabs
                    variant="scrollable"
                    scrollButtons="auto"
                    value={index}
                    onChange={handleTabChange}
                    aria-label="Tabs"
                    sx={{
                        '& .MuiTabScrollButton-root.Mui-disabled': {
                            opacity: 1, // Ensure the button is visible
                            color: '#949494', // Set the gray color
                        },
                    }}
                >
                    {attributes.mediaGroups.map( (mediaGroup:any, i:number) => (
                        <TabStyled key={i} icon={<IconImageGroups imageGroup={mediaGroup}/>} {...a11yProps(i)} />
                    ))}
                </Tabs>  
                <CreateMediaGroupDropdown 
                    attributes={attributes}
                    setAttributes={setAttributes}
                    index={index}
                    setIndex={setIndex}
                />             
            </Stack>    


            {attributes.mediaGroups.map( (tab:any, i:number) => (
                <TabPanel key={i} value={index} index={i}>
                    {/* <SingleGroupControls
                        attributes={attributes} 
                        setAttributes={setAttributes} 
                        setMediaGroups={setMediaGroups}
                        index={index}
                        setIndex={setIndex}
                    /> */}
                    This menu is not done yet, please use the sidebar media group manager. Thank you for patience!{i}
                </TabPanel>
            ))}   

            {/* Tab(all): JsonEditAll, */}
            {/* Tab(i): actionButtons, duration, JsonEditX  */}
            {/* Preview (i, or all) */}
            {/* Save Button */}
        </>
    )
}

